
<?php $__env->startSection('main'); ?>
<style>
    .vip-badge {
        background: linear-gradient(90deg, #FFD700, #FFC107, #FFD700);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        font-weight: bold;
    }
    .investment-progress {
        height: 6px;
        border-radius: 3px;
    }
    .card-clickable {
        transition: transform 0.3s ease;
        cursor: pointer;
    }
    .card-clickable:hover {
        transform: translateY(-3px);
    }
</style>

<div class="container">
    <div class="page-inner">
        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row pt-2 pb-4">
            <div>
                <h3 class="fw-bold mb-3">VIP Members & Investments</h3>
            </div>
            <div class="ms-md-auto py-2 py-md-0">
                <span class="badge bg-gold text-dark">
                    <i class="fas fa-crown me-1"></i>
                    Total Active VIP Investments: <?php echo e(\App\Models\UserVipInvestment::active()->count()); ?>

                </span>
            </div>
        </div>
        
        <div class="row">
            <!-- VIP Members Summary -->
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="card-title">VIP Members Summary</h4>
                        <div>
                            <span class="badge bg-primary me-2">
                                Total Members: <?php echo e($vipMembers->total()); ?>

                            </span>
                            <span class="badge bg-success">
                                Active Investments: $<?php echo e(number_format(\App\Models\UserVipInvestment::active()->sum('amount'), 2)); ?>

                            </span>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="bg-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Member</th>
                                        <th>Contact</th>
                                        <th>Active Investments</th>
                                        <th>Total Invested</th>
                                        <th>Daily Earnings</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $vipMembers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>#<?php echo e($member->id); ?></td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-sm me-3">
                                                    <span class="avatar-title rounded-circle bg-primary text-white">
                                                        <?php echo e(strtoupper(substr($member->name, 0, 1))); ?>

                                                    </span>
                                                </div>
                                                <div>
                                                    <h6 class="mb-0"><?php echo e($member->name); ?></h6>
                                                    <small class="text-muted">
                                                        <?php if($member->isVip): ?>
                                                            <span class="vip-badge">VIP Member</span>
                                                        <?php else: ?>
                                                            <span class="text-muted">Standard</span>
                                                        <?php endif; ?>
                                                    </small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div>
                                                <i class="fas fa-phone me-2 text-muted"></i> <?php echo e($member->phone); ?>

                                            </div>
                                            <div>
                                                <i class="fas fa-envelope me-2 text-muted"></i> 
                                                <small><?php echo e($member->email); ?></small>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-primary">
                                                <?php echo e($member->vipInvestments()->active()->count()); ?>

                                            </span>
                                        </td>
                                        <td class="text-success fw-bold">
                                            $<?php echo e(number_format($member->vipInvestments()->active()->sum('amount'), 2)); ?>

                                        </td>
                                        <td class="text-warning fw-bold">
                                            $<?php echo e(number_format($member->vipInvestments()->active()->sum('daily_earnings'), 2)); ?>/day
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('admin.vip.member.details', $member->id)); ?>" 
                                               class="btn btn-sm btn-primary">
                                                <i class="fas fa-eye"></i> View
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            <?php echo e($vipMembers->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
            
            <!-- VIP Products Investment Summary -->
            <div class="col-md-12 mt-4">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">VIP Products Performance</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Product</th>
                                        <th>Active Investors</th>
                                        <th>Total Invested</th>
                                        <th>Daily Payouts</th>
                                        <th>Avg. Investment</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = \App\Models\VipProduct::withCount(['investments' => function($q) {
                                        $q->where('is_active', true)->where('expires_at', '>', now());
                                    }])->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $investments = $product->investments()->active()->get();
                                        $totalInvested = $investments->sum('amount');
                                        $investorCount = $investments->count();
                                    ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo e($product->investment_tool); ?></strong>
                                            <div class="progress investment-progress mt-2">
                                                <div class="progress-bar bg-success" role="progressbar" 
                                                     style="width: <?php echo e(min(100, $investorCount * 10)); ?>%" 
                                                     aria-valuenow="<?php echo e($investorCount); ?>" 
                                                     aria-valuemin="0" 
                                                     aria-valuemax="10">
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo e($investorCount); ?></td>
                                        <td>$<?php echo e(number_format($totalInvested, 2)); ?></td>
                                        <td>$<?php echo e(number_format($investments->sum('daily_earnings'), 2)); ?>/day</td>
                                        <td>$<?php echo e($investorCount > 0 ? number_format($totalInvested/$investorCount, 2) : 0); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.admin_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ctrapple/public_html/resources/views/admin/vip_members/index.blade.php ENDPATH**/ ?>