
<?php $__env->startSection('main'); ?>

<div class="main-header">
    <!-- Navbar/Header Content -->
</div>
<br>
<div class="container mt-4">
    <div class="page-inner">
        <div class="page-header d-flex justify-content-between align-items-center">
            <h4 class="mb-0">
                <i class="fas fa-crown me-2"></i> VIP Categories
            </h4>
            <a href="<?php echo e(route('admin.vip-categories.create')); ?>" class="btn btn-primary btn-sm">
                <i class="fas fa-plus me-1"></i> Add Category
            </a>
        </div>

        <div class="row">
            <div class="col-md-12">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i> <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i> <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="bg-light">
                                    <tr>
                                        <th class="text-center">#</th>
                                        <th class="text-center">Icon</th>
                                        <th>Category</th>
                                        <th class="text-center">Products</th>
                                        <th class="text-center">Status</th>
                                        <th class="text-center">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr data-id="<?php echo e($category->id); ?>">
                                        <td class="text-center"><?php echo e($loop->iteration); ?></td>
                                        <td class="text-center">
                                            <div class="icon-wrapper">
                                                <i class="fas fa-<?php echo e($category->icon); ?> vip-icon"></i>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex flex-column">
                                                <span class="fw-bold"><?php echo e($category->name); ?></span>
                                                <small class="text-muted"><?php echo e($category->display_name); ?></small>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-primary rounded-pill px-3">
                                                <?php echo e($category->products_count); ?>

                                            </span>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge rounded-pill py-1 px-3 status-badge bg-<?php echo e($category->is_active ? 'success' : 'secondary'); ?>">
                                                <?php echo e($category->is_active ? 'Active' : 'Inactive'); ?>

                                            </span>
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="<?php echo e(route('admin.vip-categories.edit', $category->id)); ?>" 
                                                   class="btn btn-outline-primary" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" 
                                                        class="btn btn-outline-<?php echo e($category->is_active ? 'danger' : 'success'); ?> toggle-btn"
                                                        onclick="toggleStatus(<?php echo e($category->id); ?>)"
                                                        title="<?php echo e($category->is_active ? 'Deactivate' : 'Activate'); ?>">
                                                    <i class="fas fa-power-off"></i>
                                                </button>
                                                <form action="<?php echo e(route('admin.vip-categories.destroy', $category->id)); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" 
                                                            class="btn btn-outline-danger"
                                                            onclick="return confirm('Are you sure to delete this category?')"
                                                            title="Delete">
                                                        <i class="fas fa-trash-alt"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6" class="text-center py-4">
                                            <div class="d-flex flex-column align-items-center">
                                                <i class="fas fa-folder-open fa-2x text-muted mb-3"></i>
                                                <h5 class="text-muted">No VIP Categories Found</h5>
                                                <a href="<?php echo e(route('admin.vip-categories.create')); ?>" class="btn btn-primary btn-sm mt-2">
                                                    <i class="fas fa-plus me-1"></i> Create First Category
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function toggleStatus(categoryId) {
    Swal.fire({
        title: 'Change Status?',
        text: "You're about to change this category's status",
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, change it!',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            axios.post(`/admin/vip-categories/${categoryId}/toggle-status`)
                .then(response => {
                    const row = $(`tr[data-id="${categoryId}"]`);
                    const statusBadge = row.find('.status-badge');
                    const toggleButton = row.find('.toggle-btn');
                    
                    if(response.data.new_status) {
                        statusBadge.removeClass('bg-secondary').addClass('bg-success').text('Active');
                        toggleButton.removeClass('btn-outline-success').addClass('btn-outline-danger')
                                  .attr('title', 'Deactivate');
                    } else {
                        statusBadge.removeClass('bg-success').addClass('bg-secondary').text('Inactive');
                        toggleButton.removeClass('btn-outline-danger').addClass('btn-outline-success')
                                  .attr('title', 'Activate');
                    }
                    
                    Swal.fire({
                        title: 'Success!',
                        text: response.data.message,
                        icon: 'success',
                        timer: 1500,
                        showConfirmButton: false
                    });
                })
                .catch(error => {
                    Swal.fire({
                        title: 'Error!',
                        text: error.response?.data?.message || 'Something went wrong',
                        icon: 'error'
                    });
                });
        }
    });
}
</script>
<?php $__env->stopPush(); ?>

<style>
    .table th {
        font-weight: 600;
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    .btn-group .btn {
        border-radius: 4px;
        margin: 0 2px;
    }
    .badge {
        font-weight: 500;
    }
    .status-badge, .toggle-btn {
        transition: all 0.3s ease;
    }
    /* Icon Styles */
    .icon-wrapper {
        width: 30px;
        height: 30px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    .vip-icon {
        font-size: 1.2rem;
        color: #ffc107;
        text-shadow: 0 0 5px rgba(255, 193, 7, 0.3);
    }
    .fa-star {
        color: #ffc107;
    }
    .fa-crown {
        color: #ffc107;
    }
    /* Hover effects */
    .vip-icon:hover {
        transform: scale(1.2);
        transition: transform 0.3s ease;
    }
</style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.admin_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ctrapple/public_html/resources/views/admin/vip_categories/index.blade.php ENDPATH**/ ?>