<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>সম্পর্কে জানুন - বিনিয়োগ প্ল্যাটফর্ম</title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #4CAF50;
            --primary-dark: #45a049;
            --dark-bg: #000;
            --text-light: #f8f9fa;
            --text-dark: #333;
            --text-gray: #666;
            --card-bg: #1a1a1a;
            --border-color: rgba(255,255,255,0.1);
            --success-color: #28a745;
            --error-color: #dc3545;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: var(--dark-bg);
            color: var(--text-light);
            line-height: 1.6;
            padding-bottom: 80px;
        }
        
        /* Header Styles */
        .header {
            background: linear-gradient(135deg, #000102 0%, #1e3a5f 100%);
            color: white;
            padding: 20px 0;
            position: relative;
            overflow: hidden;
        }
        
        .header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, rgba(255,255,255,0.1) 0%, transparent 50%);
            pointer-events: none;
        }
        
        .header-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: relative;
            z-index: 1;
        }
        
        /* Main Content */
        .main-content {
            background: var(--dark-bg);
            border-radius: 20px 20px 0 0;
            margin-top: -10px;
            position: relative;
            z-index: 2;
            min-height: calc(100vh - 200px);
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        
        .page-header {
            text-align: center;
            margin-bottom: 40px;
        }
        
        .page-title {
            font-size: 32px;
            font-weight: 800;
            color: white;
            margin-bottom: 10px;
        }
        
        .page-subtitle {
            font-size: 16px;
            color: rgba(255,255,255,0.7);
            font-weight: 400;
        }
        
        /* About Sections */
        .about-section {
            margin-bottom: 50px;
            animation: fadeIn 1s ease;
        }
        
        .section-title {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 25px;
            color: var(--primary-color);
            position: relative;
            padding-left: 15px;
        }
        
        .section-title::before {
            content: '';
            position: absolute;
            left: 0;
            top: 5px;
            height: 20px;
            width: 5px;
            background: var(--primary-color);
            border-radius: 5px;
        }
        
        .section-content {
            background: var(--card-bg);
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 8px 30px rgba(0,0,0,0.2);
            border: 1px solid var(--border-color);
            line-height: 1.8;
        }
        
        /* Mission Cards */
        .mission-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 25px;
            margin-top: 30px;
        }
        
        .mission-card {
            background: var(--card-bg);
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            border-top: 4px solid var(--primary-color);
            transition: transform 0.3s ease;
        }
        
        .mission-card:hover {
            transform: translateY(-5px);
        }
        
        .mission-icon {
            font-size: 40px;
            color: var(--primary-color);
            margin-bottom: 20px;
        }
        
        .mission-title {
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 15px;
            color: white;
        }
        
        /* Team Section */
        .team-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 30px;
            margin-top: 30px;
        }
        
        .team-card {
            background: var(--card-bg);
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            text-align: center;
            transition: transform 0.3s ease;
        }
        
        .team-card:hover {
            transform: translateY(-5px);
        }
        
        .team-image {
            width: 100%;
            height: 250px;
            object-fit: cover;
            border-bottom: 3px solid var(--primary-color);
        }
        
        .team-info {
            padding: 20px;
        }
        
        .team-name {
            font-size: 18px;
            font-weight: 700;
            margin-bottom: 5px;
            color: white;
        }
        
        .team-position {
            font-size: 14px;
            color: var(--primary-color);
            margin-bottom: 15px;
        }
        
        .team-social {
            display: flex;
            justify-content: center;
            gap: 15px;
        }
        
        .team-social a {
            color: rgba(255,255,255,0.7);
            transition: color 0.3s ease;
        }
        
        .team-social a:hover {
            color: var(--primary-color);
        }
        
        /* Stats Section */
        .stats-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-top: 40px;
        }
        
        .stat-card {
            background: var(--card-bg);
            border-radius: 15px;
            padding: 30px 20px;
            text-align: center;
            border-top: 4px solid var(--primary-color);
        }
        
        .stat-number {
            font-size: 42px;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 10px;
            line-height: 1;
        }
        
        .stat-label {
            font-size: 16px;
            color: rgba(255,255,255,0.8);
        }
        
        /* Footer Menu */
        .footer-menu {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: #1a1a1a;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
            z-index: 1000;
        }
        
        .footer-content {
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 15px 20px;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .footer-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: #cccccc;
            transition: all 0.3s ease;
            padding: 8px;
            border-radius: 10px;
        }
        
        .footer-item:hover,
        .footer-item.active {
            color: #ffffff;
            background: rgba(255, 255, 255, 0.1);
        }
        
        .footer-icon {
            font-size: 20px;
            margin-bottom: 5px;
        }
        
        .footer-text {
            font-size: 12px;
            font-weight: 500;
        }
        
        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .page-title {
                font-size: 28px;
            }
            
            .section-title {
                font-size: 22px;
            }
            
            .mission-cards, .team-grid, .stats-container {
                grid-template-columns: 1fr;
            }
            
            .section-content {
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header Section -->
        <header class="header">
            <div class="header-content">
                <h1>সম্পর্কে জানুন</h1>
            </div>
        </header>

        <!-- Main Content -->
        <main class="main-content">
            <div class="container">
                <!-- Page Title -->
                <div class="page-header">
                    <h1 class="page-title">আমাদের সম্পর্কে</h1>
                    <p class="page-subtitle">আপনার আর্থিক সাফল্যের জন্য আমাদের অঙ্গীকার</p>
                </div>
                
                <!-- About Company Section -->
                <div class="about-section">
                    <h2 class="section-title">আমাদের কোম্পানি</h2>
                    <div class="section-content">
                       <?php if($about && $about->description): ?>
    <p><?php echo e($about->description); ?></p>
<?php endif; ?>

                        
                       
                    </div>
                </div>
                
                <!-- Our Mission Section -->
                <div class="about-section">
                    <h2 class="section-title">আমাদের মিশন ও ভিশন</h2>
                    <div class="section-content">
                        <div class="mission-cards">
                            <div class="mission-card">
                                <div class="mission-icon">
                                    <i class="fas fa-bullseye"></i>
                                </div>
                                <h3 class="mission-title">আমাদের মিশন</h3>
                                <p>সকলের জন্য সহজ, নিরাপদ ও লাভজনক বিনিয়োগ সুযোগ তৈরি করা এবং আর্থিক সাক্ষরতা বৃদ্ধির মাধ্যমে দেশের অর্থনৈতিক উন্নয়নে ভূমিকা রাখা।</p>
                            </div>
                            
                            <div class="mission-card">
                                <div class="mission-icon">
                                    <i class="fas fa-eye"></i>
                                </div>
                                <h3 class="mission-title">আমাদের ভিশন</h3>
                                <p>২০২৫ সালের মধ্যে বাংলাদেশের সবচেয়ে নির্ভরযোগ্য ও উদ্ভাবনী বিনিয়োগ প্ল্যাটফর্ম হিসেবে প্রতিষ্ঠিত হওয়া এবং ১০ লক্ষ ব্যবহারকারীর আস্থা অর্জন করা।</p>
                            </div>
                            
                            <div class="mission-card">
                                <div class="mission-icon">
                                    <i class="fas fa-handshake"></i>
                                </div>
                                <h3 class="mission-title">আমাদের মূল্যবোধ</h3>
                                <p>স্বচ্ছতা, নৈতিকতা ও উদ্ভাবন - এই তিন মূলনীতির উপর ভিত্তি করে আমরা আমাদের প্রতিটি সিদ্ধান্ত গ্রহণ করি এবং সেবা প্রদান করি।</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Our Team Section -->
            
                
                <!-- Our Achievements -->
                <div class="about-section">
                    <h2 class="section-title">আমাদের অর্জন</h2>
                    <div class="section-content">
                        <p>গত কয়েক বছরে আমরা আমাদের ব্যবহারকারীদের আস্থা ও সমর্থনে অনেক দূর এগিয়েছি। আমাদের সাফল্যের কিছু সংখ্যা:</p>
                        
                        <div class="stats-container">
                            <div class="stat-card">
                                <div class="stat-number">৫০০K+</div>
                                <div class="stat-label">সক্রিয় ব্যবহারকারী</div>
                            </div>
                            
                            <div class="stat-card">
                                <div class="stat-number">৳২৫০Cr+</div>
                                <div class="stat-label">বিনিয়োগকৃত অর্থ</div>
                            </div>
                            
                            <div class="stat-card">
                                <div class="stat-number">৯৮%</div>
                                <div class="stat-label">গ্রাহক সন্তুষ্টি</div>
                            </div>
                            
                            <div class="stat-card">
                                <div class="stat-number">১০+</div>
                                <div class="stat-label">আন্তর্জাতিক পুরস্কার</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Footer Menu -->
    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Animation on scroll
            const animateOnScroll = () => {
                const elements = document.querySelectorAll('.about-section, .mission-card, .team-card, .stat-card');
                
                elements.forEach(element => {
                    const elementPosition = element.getBoundingClientRect().top;
                    const screenPosition = window.innerHeight / 1.2;
                    
                    if (elementPosition < screenPosition) {
                        element.style.opacity = '1';
                        element.style.transform = 'translateY(0)';
                    }
                });
            };
            
            // Set initial state for animation
            document.querySelectorAll('.about-section, .mission-card, .team-card, .stat-card').forEach(el => {
                el.style.opacity = '0';
                el.style.transform = 'translateY(20px)';
                el.style.transition = 'all 0.5s ease';
            });
            
            animateOnScroll();
            window.addEventListener('scroll', animateOnScroll);
        });
    </script>
</body>
</html><?php /**PATH /home/ctrapple/public_html/resources/views/about.blade.php ENDPATH**/ ?>