
<?php $__env->startSection('main'); ?>
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Global SEO Settings</h3>
        </div>
        <form action="<?php echo e(route('admin.seo.save-global')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="card-body">
                <div class="form-group">
                    <label>Default Meta Title</label>
                    <input type="text" name="meta_title" class="form-control" 
                           value="<?php echo e(old('meta_title', $globalSeo->meta_title)); ?>" required>
                    <small>Recommended: 50-60 characters</small>
                </div>

                <div class="form-group">
                    <label>Default Meta Description</label>
                    <textarea name="meta_description" class="form-control" rows="3" required>
                        <?php echo e(old('meta_description', $globalSeo->meta_description)); ?>

                    </textarea>
                    <small>Recommended: 150-160 characters</small>
                </div>

                <div class="form-group">
                    <label>Default Keywords</label>
                    <input type="text" name="meta_keywords" class="form-control" 
                           value="<?php echo e(old('meta_keywords', $globalSeo->meta_keywords)); ?>" required>
                    <small>Comma separated list</small>
                </div>

                <div class="form-group">
                    <label>Default OG Image</label>
                    <input type="file" name="og_image" class="form-control-file">
                    <?php if($globalSeo->og_image): ?>
                        <img src="<?php echo e($globalSeo->og_image); ?>" height="100" class="mt-2 d-block">
                    <?php endif; ?>
                </div>
            </div>
            <div class="card-footer">
                <button type="submit" class="btn btn-primary">Save Global Settings</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.admin_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ctrapple/public_html/resources/views/admin/seo/global.blade.php ENDPATH**/ ?>