

<?php $__env->startSection('main'); ?>
<div class="card">
    <div class="card-header">
        <h4 class="card-title">ভিআইপি পেন্ডিং আয়ের তালিকা</h4>
    </div>
    <div class="card-body">
        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>
        
        <?php if(session('error')): ?>
            <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
        <?php endif; ?>

        <?php if($pendingInvestments->isEmpty()): ?>)
            <div class="alert alert-info">কোন পেন্ডিং আয় পাওয়া যায়নি</div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>ইউজার</th>
                            <th>প্রোডাক্ট</th>
                            <th>আয়ের পরিমাণ</th>
                            <th>শেষ পেমেন্ট</th>
                            <th>বাকি সময়</th>
                            <th>স্ট্যাটাস</th>
                            <th>অ্যাকশন</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $pendingInvestments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td>
                                <?php if($investment->user): ?>
                                    <?php echo e($investment->user->name); ?>

                                <?php else: ?>
                                    ইউজার পাওয়া যায়নি
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($investment->product): ?>
                                    <?php echo e($investment->product->investment_tool); ?>

                                <?php else: ?>
                                    প্রোডাক্ট পাওয়া যায়নি
                                <?php endif; ?>
                            </td>
                            <td><?php echo e(number_format($investment->daily_earnings, 2)); ?> ৳</td>
                            <td>
                                <?php if($investment->last_payout_at): ?>
                                    <?php echo e($investment->last_payout_at->format('d M Y h:i A')); ?>

                                <?php else: ?>
                                    প্রথম বার
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($investment->last_payout_at): ?>
                                    <?php
                                        $nextPayoutTime = $investment->last_payout_at->addHours(24);
                                        $remainingTime = now()->diff($nextPayoutTime);
                                    ?>
                                    
                                    <?php if(now() >= $nextPayoutTime): ?>
                                        <span class="badge badge-success">প্রস্তুত</span>
                                    <?php else: ?>
                                        <?php echo e($remainingTime->format('%h ঘণ্টা %i মিনিট')); ?>

                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="badge badge-success">প্রস্তুত</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($investment->expires_at <= now()): ?>
                                    <span class="badge badge-danger">মেয়াদ শেষ</span>
                                <?php elseif(!$investment->is_active): ?>
                                    <span class="badge badge-secondary">নিষ্ক্রিয়</span>
                                <?php else: ?>
                                    <span class="badge badge-success">সক্রিয়</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($investment->is_active && $investment->expires_at > now() && (!$investment->last_payout_at || $investment->last_payout_at <= now()->subHours(24))): ?>
                                <form action="<?php echo e(route('admin.vip.process-single-earning', $investment->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm btn-primary">
                                        প্রসেস করুন
                                    </button>
                                </form>
                                <?php else: ?>
                                <button class="btn btn-sm btn-secondary" disabled>প্রসেস করুন</button>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.admin_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ctrapple/public_html/resources/views/admin/vip/pending_earnings.blade.php ENDPATH**/ ?>