<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminController;

use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\VipCategoryController;
use App\Http\Controllers\Admin\VipProductController;
use App\Http\Controllers\Admin\AdminPaymentMethodController;
use App\Http\Controllers\Admin\AdminTransactionController;
use App\Http\Controllers\Frontend\InvestmentController;
use App\Http\Controllers\Frontend\TeamController;
use App\Http\Controllers\Frontend\TransactionController;
use App\Http\Controllers\Frontend\PaymentMethodController;
use App\Http\Controllers\Admin\SupportSettingController;
use App\Http\Controllers\Frontend\WithdrawalController;
use App\Http\Controllers\Admin\AdminWithdrawalController;
use App\Http\Controllers\Frontend\VipInvestmentController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\SeoController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\CommissionController;
use App\Http\Controllers\Admin\AboutController;
use App\Http\Controllers\ErrorController;



/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::get('/', function () {
    // If user is already logged in or has remember me cookie, redirect to dashboard
    if (auth()->check() || request()->hasCookie('remember_me')) {
        return redirect()->route('dashboard');
    }
    
    return view('auth.login');
});

Route::prefix('admin')->group(function(){
    Route::get('/login',[AdminController::class,'index'])->name('login_form');
    Route::post('/login/owner',[AdminController::class,'Login'])->name('admin.login');
    Route::get('/dashboard',[AdminController::class,'Dashboard'])->name('admin.dashboard')->middleware('admin');
    Route::get('/logout',[AdminController::class,'AdminLogout'])->name('admin.logout');
    Route::get('/register',[AdminController::class,'AdminRegister'])->name('admin.register');
    Route::post('/register/create',[AdminController::class,'AdminRegisterCreate'])->name('admin.register.create');
});


// Admin Profile Management Routes
Route::prefix('admin')->group(function () {
    Route::get('/profile', [AdminController::class, 'profile'])->name('admin.profile');
    Route::post('/profile/update', [AdminController::class, 'updateProfile'])->name('admin.profile.update');
    Route::get('/all', [AdminController::class, 'allAdmins'])->name('admin.all');
    Route::get('/edit/{id}', [AdminController::class, 'editAdmin'])->name('admin.edit');
    Route::post('/update/{id}', [AdminController::class, 'updateAdmin'])->name('admin.update');
    Route::get('/delete/{id}', [AdminController::class, 'deleteAdmin'])->name('admin.delete');
});


Route::prefix('admin')->middleware(['admin'])->group(function () {
    Route::get('/vip-members', [AdminController::class, 'vipMembers'])->name('admin.vip.members');
    Route::get('/vip-members/{id}', [AdminController::class, 'vipMemberDetails'])->name('admin.vip.member.details');
});


// routes/admin.php

Route::prefix('admin')->middleware(['admin'])->group(function () {

    // Pages Management
    Route::resource('pages', PageController::class);
    
    // SEO Management
  Route::prefix('seo')->group(function () {
        Route::get('/', [SeoController::class, 'index'])->name('admin.seo.index');
        Route::get('global', [SeoController::class, 'global'])->name('admin.seo.global');
        Route::post('global', [SeoController::class, 'saveGlobal'])->name('admin.seo.save-global');
        Route::get('{id}/edit', [SeoController::class, 'edit'])->name('admin.seo.edit');
        Route::put('{id}', [SeoController::class, 'update'])->name('admin.seo.update');
    });
    Route::get('settings', [SettingController::class, 'index'])->name('admin.settings');
    Route::put('settings', [SettingController::class, 'update'])->name('admin.settings.update');
    Route::post('settings/upload', [SettingController::class, 'upload'])->name('admin.settings.upload');
    
    // Media Manager
    Route::get('media', [MediaController::class, 'index'])->name('admin.media');
    Route::post('media/upload', [MediaController::class, 'upload'])->name('admin.media.upload');
});


// routes/web.php

Route::prefix('admin')->middleware(['admin'])->group(function () {
    // Existing routes...
    
    Route::post('/users/{id}/update-balance', [UserController::class, 'updateBalance'])
         ->name('admin.user.balance.update');
         
         
});


Route::prefix('admin')->name('admin.')->middleware(['auth:admin'])->group(function() {
    // ... your other admin routes
    
    // Add this new route
    Route::post('/users/{user}/update-balance', [\App\Http\Controllers\Admin\UserController::class, 'updateBalance'])
         ->name('users.updateBalance');
});



Route::group(['prefix' => 'admin', 'middleware' => ['auth:admin']], function() {
    // ম্যানুয়ালি সবগুলো প্রসেস করার রাউট
    Route::post('/vip/process-earnings', [\App\Http\Controllers\Admin\VipController::class, 'processEarningsManually'])
        ->name('admin.vip.process-earnings');
    
    // পেন্ডিং আয়ের তালিকা দেখার রাউট
    Route::get('/vip/pending-earnings', [\App\Http\Controllers\Admin\VipController::class, 'pendingEarnings'])
        ->name('admin.vip.pending-earnings');
        
    // একক ইনভেস্টমেন্ট প্রসেস করার রাউট
    Route::post('/vip/process-single-earning/{id}', [\App\Http\Controllers\Admin\VipController::class, 'processSingleEarning'])
        ->name('admin.vip.process-single-earning');
});

Route::prefix('admin')->middleware(['admin'])->group(function () {
    Route::get('/users', [UserController::class, 'index'])->name('admin.users');
    Route::get('/user/status/{id}', [UserController::class, 'toggleStatus'])->name('admin.user.status');
    Route::delete('/admin/users/delete/{id}', [UserController::class, 'destroy'])->name('admin.user.delete');
});


Route::post('/admin/vip/process-earnings', [\App\Http\Controllers\Admin\VipController::class, 'processEarningsManually'])
    ->middleware('auth:admin')
    ->name('admin.vip.process-earnings');
    
    
    
    // মেইন 404 রাউট (সব ধরনের 404 এরর হ্যান্ডেল করবে)
Route::fallback([ErrorController::class, 'handleFallback']);

// ইউজার প্যানেলের জন্য 404 (ঐচ্ছিক)
Route::get('/404', [ErrorController::class, 'notFound'])->name('404');

// অ্যাডমিন গ্রুপের মধ্যে
Route::middleware(['auth:admin'])->group(function () {
    Route::get('/admin/404', [ErrorController::class, 'adminNotFound'])->name('admin.404');
});
    
    
    
   
Route::prefix('admin')->middleware(['admin'])->group(function () {
    // ... existing routes ...

Route::post('/admin/users/balance-update/{id}', [\App\Http\Controllers\Admin\UserController::class, 'updateBalance'])->name('admin.user.balance.update');
       


});




Route::prefix('admin')->name('admin.')->group(function () {
    // VIP Categories Routes
    Route::get('vip-categories', [VipCategoryController::class, 'index'])->name('vip-categories.index');
    Route::get('vip-categories/create', [VipCategoryController::class, 'create'])->name('vip-categories.create');
    Route::post('vip-categories', [VipCategoryController::class, 'store'])->name('vip-categories.store');
    Route::get('vip-categories/{id}/edit', [VipCategoryController::class, 'edit'])->name('vip-categories.edit');
    Route::put('vip-categories/{id}', [VipCategoryController::class, 'update'])->name('vip-categories.update');
    Route::delete('vip-categories/{id}', [VipCategoryController::class, 'destroy'])->name('vip-categories.destroy');
    Route::post('vip-categories/{id}/toggle-status', [VipCategoryController::class, 'toggleStatus'])->name('vip-categories.toggle-status');

    // VIP Products Routes
    Route::get('vip-products', [VipProductController::class, 'index'])->name('vip-products.index');
    Route::get('vip-products/create', [VipProductController::class, 'create'])->name('vip-products.create');
    Route::post('vip-products', [VipProductController::class, 'store'])->name('vip-products.store');
    Route::get('vip-products/{id}/edit', [VipProductController::class, 'edit'])->name('vip-products.edit');
    Route::put('vip-products/{id}', [VipProductController::class, 'update'])->name('vip-products.update');
    Route::delete('vip-products/{id}', [VipProductController::class, 'destroy'])->name('vip-products.destroy');
});
// routes/web.php
Route::get('/payment-methods', [PaymentMethodController::class, 'getActiveMethods']);

Route::middleware(['admin', 'admin'])->prefix('admin')->group(function () {
    // Payment Methods Routes
    Route::get('/payment-methods', [AdminPaymentMethodController::class, 'index'])->name('admin.payment-methods');
    Route::get('/payment-methods/create', [AdminPaymentMethodController::class, 'create'])->name('admin.payment-methods.create');
    Route::post('/payment-methods', [AdminPaymentMethodController::class, 'store'])->name('admin.payment-methods.store');
    Route::get('/payment-methods/{method}/edit', [AdminPaymentMethodController::class, 'edit'])->name('admin.payment-methods.edit');
    Route::put('/payment-methods/{method}', [AdminPaymentMethodController::class, 'update'])->name('admin.payment-methods.update');
Route::delete('/payment-methods/{method}', [AdminPaymentMethodController::class, 'destroy'])
     ->name('admin.payment-methods.destroy');
    Route::post('/payment-methods/{method}/status', [AdminPaymentMethodController::class, 'updateStatus'])->name('admin.payment-methods.status');
    Route::post('/payment-methods/update-order', [AdminPaymentMethodController::class, 'updateOrder'])->name('admin.payment-methods.update-order');
});

Route::middleware(['auth', 'verified'])->group(function () {
    // Dashboard Route
    Route::get('/risk-check', [DashboardController::class, 'riskCheck'])->name('vip.investment.tips');

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
});
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Admin Transactions Routes
Route::prefix('admin')->middleware(['admin'])->group(function () {
    Route::get('/transactions', [AdminTransactionController::class, 'allTransactions'])->name('admin.transactions.all');
    Route::get('/transactions/pending', [AdminTransactionController::class, 'pendingTransactions'])->name('admin.transactions.pending');
    Route::get('/transactions/approved', [AdminTransactionController::class, 'approvedTransactions'])->name('admin.transactions.approved');
    Route::get('/transactions/rejected', [AdminTransactionController::class, 'rejectedTransactions'])->name('admin.transactions.rejected');
    Route::post('/transactions/{transaction}/status', [AdminTransactionController::class, 'updateStatus'])
         ->name('admin.transactions.status');
    Route::delete('/transactions/{transaction}', [AdminTransactionController::class, 'destroy'])->name('admin.transactions.destroy');
});
// Admin Routes
Route::prefix('admin')->middleware(['admin'])->group(function () {
    Route::get('/support', [SupportSettingController::class, 'edit'])->name('admin.support.edit');
    Route::post('/support', [SupportSettingController::class, 'update'])->name('admin.support.update');
});


Route::prefix('admin')->middleware(['admin'])->group(function () {
    Route::get('/about', [AboutController::class, 'edit'])->name('admin.about.edit');
    Route::put('/about', [AboutController::class, 'update'])->name('admin.about.update');
});

Route::middleware('auth')->group(function () {
  
  
    // Transaction history
    Route::get('/about', [AboutController::class, 'show'])->name('about.show');
});
// Frontend Route
Route::get('/support', function () {
    $support = \App\Models\SupportSetting::first();
    return view('frontend.support', compact('support'));
})->name('support');


Route::middleware('auth')->group(function () {
    // Deposit routes
    Route::get('/deposit', [TransactionController::class, 'deposit'])->name('deposit');
    Route::post('/deposit', [TransactionController::class, 'depositStore'])->name('deposit.store');
    
  
    // Transaction history
    Route::get('/transactions', [TransactionController::class, 'index'])->name('transactions');
});

// এডমিন রাউটস
Route::prefix('admin')->middleware(['admin'])->group(function () {
    Route::get('/commissions/edit', [CommissionController::class, 'edit'])->name('admin.commissions.edit');
    Route::put('/commissions', [CommissionController::class, 'update'])->name('admin.commissions.update');
});

// ফ্রন্টএন্ড রাউট
Route::get('/commissions', function () {
    $commission = App\Models\Commission::first();
    return view('commissions', compact('commission'));
})->name('commissions');



// User routes
Route::middleware('auth')->group(function () {
    Route::get('/withdraw', [WithdrawalController::class, 'index'])->name('withdraw.index');
    Route::post('/withdraw', [WithdrawalController::class, 'store'])->name('withdraw.store');
});

// Admin routes
Route::prefix('admin')->middleware(['admin'])->group(function () {
    Route::get('/withdrawals', [AdminWithdrawalController::class, 'index'])->name('admin.withdrawals.index');
    Route::get('/withdrawals/pending', [AdminWithdrawalController::class, 'pending'])->name('admin.withdrawals.pending');
    Route::get('/withdrawals/approved', [AdminWithdrawalController::class, 'approved'])->name('admin.withdrawals.approved');
    Route::get('/withdrawals/rejected', [AdminWithdrawalController::class, 'rejected'])->name('admin.withdrawals.rejected');
    Route::post('/withdrawals/{withdrawal}/approve', [AdminWithdrawalController::class, 'approve'])->name('admin.withdrawals.approve');
    Route::post('/withdrawals/{withdrawal}/reject', [AdminWithdrawalController::class, 'reject'])->name('admin.withdrawals.reject');
    Route::post('/withdrawals/{withdrawal}/process', [AdminWithdrawalController::class, 'process'])->name('admin.withdrawals.process');
// routes/web.php

Route::delete('/withdrawals/{withdrawal}', [AdminWithdrawalController::class, 'destroy'])->name('admin.withdrawals.destroy');
});

// routes/web.php
Route::middleware('auth')->group(function () {
    Route::post('/invest/vip/{product}', [VipInvestmentController::class, 'invest'])->name('vip.invest');
    Route::get('/investments', [InvestmentController::class, 'index'])->name('investments.index');
    
    // Admin route to manually trigger earnings (for testing)
    Route::get('/admin/process-vip-earnings', [VipInvestmentController::class, 'processDailyEarnings'])
        ->middleware('admin')
        ->name('admin.process.vip.earnings');
});

// routes/web.php
Route::middleware('auth')->group(function () {
    Route::get('/my-account', [UserController::class, 'myAccount'])->name('my.account');
    Route::post('/user/update-name', [UserController::class, 'updateName'])->name('user.update-name');

    // ... other auth routes
});

Route::middleware(['auth'])->group(function () {
    Route::get('/investments', [InvestmentController::class, 'index'])->name('investments.index');
 Route::get('/team', [TeamController::class, 'index'])->name('team.index');
 
});
require __DIR__.'/auth.php';
