<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ট্রানজেকশন হিস্ট্রি</title>
    <style>
        body {
            font-family: 'Hind Siliguri', Arial, sans-serif;
            background-color: #f5f7fa;
            margin: 0;
            padding: 0;
            color: #333;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
        }
        .header h1 {
            color: #2c3e50;
            font-size: 24px;
            margin: 0;
        }
        .back-button {
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
        }
        .transaction-card {
            background: white;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 15px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .transaction-header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .transaction-type {
            font-weight: bold;
            color: #2c3e50;
        }
        .transaction-amount {
            font-weight: bold;
        }
        .deposit {
            color: #27ae60;
        }
        .withdraw {
            color: #e74c3c;
        }
        .transaction-details {
            display: flex;
            justify-content: space-between;
            font-size: 14px;
            color: #7f8c8d;
        }
        .transaction-method {
            display: flex;
            align-items: center;
        }
        .method-icon {
            width: 20px;
            height: 20px;
            margin-right: 5px;
        }
        .transaction-date {
            text-align: right;
        }
        .status {
            padding: 3px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
        }
        .pending {
            background-color: #f39c12;
            color: white;
        }
        .approved {
            background-color: #27ae60;
            color: white;
        }
        .rejected {
            background-color: #e74c3c;
            color: white;
        }
        .empty-state {
            text-align: center;
            padding: 40px 0;
            color: #7f8c8d;
        }
    </style>
</head>
<body>
    <div class="container">
       <div class="header">
    <a href="{{ route('dashboard') }}" class="back-button">←</a>
    <h1>ট্রানজেকশন হিস্ট্রি</h1>
    <div></div> <!-- Empty div for alignment -->
</div>


        @if($transactions->count() > 0)
            @foreach($transactions as $transaction)
            <div class="transaction-card">
                <div class="transaction-header">
                    <span class="transaction-type">
                        @if($transaction->type == 'deposit')
                            ডিপোজিট
                        @else
                            উত্তোলন
                        @endif
                    </span>
                    <span class="transaction-amount {{ $transaction->type }}">
                        ৳{{ number_format($transaction->amount, 2) }}
                    </span>
                </div>
                <div class="transaction-details">
                   <div class="transaction-method">
    @if($transaction->paymentMethod)
        <img src="{{ asset($transaction->paymentMethod->icon) }}" 
             alt="{{ $transaction->paymentMethod->name }}" 
             class="method-icon">
        {{ ucfirst($transaction->paymentMethod->name) }}
    @else
        {{ $transaction->method }}
    @endif

    <span class="status {{ $transaction->status }}">
        @if($transaction->status == 'pending')
            পেন্ডিং
        @elseif($transaction->status == 'approved')
            অ্যাপ্রুভড
        @else
            রিজেক্টেড
        @endif
    </span>
</div>

                    <div class="transaction-date">
                        {{ $transaction->created_at->format('d M Y h:i A') }}
                    </div>
                </div>
                @if($transaction->transaction_id)
                <div class="transaction-id" style="margin-top: 10px; font-size: 13px; color: #7f8c8d;">
                    ট্রানজেকশন আইডি: {{ $transaction->transaction_id }}
                </div>
                @endif
            </div>
            @endforeach
        @else
            <div class="empty-state">
                <p>কোন ট্রানজেকশন পাওয়া যায়নি</p>
            </div>
        @endif
    </div>
</body>
</html>