<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Apple AI - ড্যাশবোর্ড</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('Frontend/styles.css') }}">
</head>
<body>
    <!-- Header Section -->
    <header class="header">
        <div class="top-bar">
            <div class="top-bar-content">
                <div class="logo-section">
                    <i class="fab fa-apple apple-icon"></i>
                    <span class="brand-name">Apple AI</span>
                </div>
                
                <div class="language-dropdown">
                    <button class="dropdown-btn" id="languageBtn">
                        <i class="fas fa-flag"></i>
                        🇧🇩 বাংলাদেশ
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="dropdown-content" id="languageDropdown">
                        <a href="#" class="dropdown-item">🇧🇩 বাংলাদেশ</a>
                        <a href="#" class="dropdown-item">🇺🇸 যুক্তরাষ্ট্র</a>
                        <a href="#" class="dropdown-item">🇬🇧 যুক্তরাজ্য</a>
                        <a href="#" class="dropdown-item">🇮🇳 ভারত</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="main-header">
            <div class="header-content">
                <div class="main-logo">
                    <i class="fab fa-apple main-apple-icon"></i>
                    <h1 class="main-title">Apple AI</h1>
                </div>
            </div>
        </div>

        <div class="container">
        <a href="{{ route('deposit') }}" class="card recharge-card">
            <h2 class="card-title">রিচার্জ</h2>
            <div class="background-icons">
                <i class="fas fa-credit-card card-icon"></i>
                <i class="fas fa-bolt bolt-icon"></i>
            </div>
            <div class="action-button">
                <i class="fas fa-chevron-right"></i>
                <span class="sr-only">রিচার্জ করুন</span>
            </div>
        </a>

        <a href="{{ route('withdraw.index') }}" class="card withdraw-card">
            <h2 class="card-title">উত্তোলন</h2>
            <div class="background-icons">
                <i class="fas fa-arrow-left arrow-icon"></i>
            </div>
            <div class="action-button">
                <i class="fas fa-chevron-right"></i>
                <span class="sr-only">উত্তোলন করুন</span>
            </div>
        </a>
    </div>
    </header>

    <!-- Dashboard Content -->
    @yield('content')

    <!-- Footer Menu -->
   
@include('layouts.footer')
    <script src="script.js"></script>
</body>
</html>
