<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>404 - Page Not Found</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .error-container {
            padding: 40px 0;
            min-height: 70vh;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        .error-code {
            font-size: 120px;
            color: #dc3545;
            font-weight: 700;
            line-height: 1;
        }
        .error-title {
            font-size: 36px;
            margin: 20px 0;
            color: #343a40;
        }
        .error-message {
            font-size: 18px;
            color: #6c757d;
            margin-bottom: 30px;
        }
        .error-actions .btn {
            padding: 10px 20px;
            font-size: 18px;
        }
        @media (max-width: 768px) {
            .error-code {
                font-size: 80px;
            }
            .error-title {
                font-size: 28px;
            }
            .error-message {
                font-size: 16px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 text-center">
                <div class="error-container">
                    <h1 class="error-code">404</h1>
                    <h2 class="error-title">পৃষ্ঠা পাওয়া যায়নি</h2>
                    <p class="error-message">আপনি যে পৃষ্ঠাটি খুঁজছেন তা বিদ্যমান নেই বা সরিয়ে ফেলা হয়েছে৷</p>
                    
                    <div class="error-actions mt-4">
                        <a href="/" class="btn btn-primary btn-lg">
                            <i class="fas fa-home"></i> হোম পেজে ফিরে যান
                        </a>
                        
                        <a href="javascript:history.back()" class="btn btn-secondary btn-lg ms-3">
                            <i class="fas fa-arrow-left"></i> পূর্ববর্তী পৃষ্ঠা
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>