@extends('index')
@section('content')

<div class="dashboard-container">
    <!-- Header Section -->
   <header class="dashboard-header">
    <div class="header-content">
        <div class="balance-section">
            <div class="balance-item">
                <div class="balance-label">মোট বিনিয়োগ</div>
                <div class="balance-value">
                    ৳{{ number_format(auth()->user()->vipInvestments()->sum('amount'), 2) }}
                </div>
            </div>
            <div class="balance-item">
                <div class="balance-label">উপলভ্য ব্যালেন্স</div>
                <div class="balance-value">
                    ৳{{ number_format(auth()->user()->balance, 2) }}
                </div>
            </div>
            <!-- ✅ নতুন Withdraw Total -->
            <div class="balance-item">
                <div class="balance-label">উত্তোলনকৃত টাকা</div>
                <div class="balance-value">
                    ৳{{ number_format($withdrawTotal, 2) }}
                </div>
            </div>
        </div>
    </div>
</header>


    <!-- Middle Section -->
    <section class="middle-section">
        <div class="feature-card" @if($popularAdvice['product']) onclick="window.location='{{ route('vip.invest', $popularAdvice['product_id']) }}'" style="cursor: pointer;" @endif>
            <div class="feature-header">
                <i class="fas fa-crown feature-icon"></i>
                <div class="feature-title">সেরা ভিআইপি প্যাকেজ</div>
                @if($popularAdvice['product'] && $popularAdvice['product']->is_featured)
                    <span class="featured-badge">ফিচার্ড</span>
                @endif
            </div>
            
            <div class="feature-product-name">{{ $popularAdvice['name'] }}</div>
            <div class="feature-user-code">আপনার আইডি: {{ $popularAdvice['user_code'] }}</div>
            
            <div class="feature-price-box">
                <span class="price-label">বিনিয়োগ:</span>
                <span class="price-value">{{ number_format($popularAdvice['price'], 2) }}৳</span>
            </div>
            
            <div class="feature-profit {{ $popularAdvice['daily_return'] >= 0 ? 'positive' : 'negative' }}">
                <i class="fas fa-arrow-{{ $popularAdvice['daily_return'] >= 0 ? 'up' : 'down' }}"></i>
                দৈনিক রিটার্ন: {{ number_format($popularAdvice['daily_return'], 2) }}%
            </div>
            
    

            @if($popularAdvice['is_available'])
                <form action="{{ route('vip.invest', $popularAdvice['product_id']) }}" method="POST" class="investment-form">
                    @csrf
                    <button type="submit" class="explore-btn">
                        <i class="fas fa-arrow-circle-right"></i>
                        এখনই বিনিয়োগ করুন
                    </button>
                </form>
            @else
       @php
    $productId = $popularAdvice['product_id'] ?? null; // Always define
    $userInvestment = null;

    if ($productId) {
        $userInvestment = auth()->user()->vipInvestments()
                              ->where('vip_product_id', $productId)
                              ->active()
                              ->first();
    }
@endphp



                @if($userInvestment)
                    <div class="invested-badge">
                        <i class="fas fa-check-circle"></i> 
                        বিনিয়োগ করা হয়েছে
                        @if($userInvestment->expires_at)
                            (মেয়াদ শেষ: {{ $userInvestment->expires_at->format('d M Y') }})
                        @endif
                    </div>
                @else
                    <button class="explore-btn" disabled>
                        <i class="fas fa-exclamation-circle"></i>
                        বর্তমানে বিনিয়োগের জন্য উপলব্ধ নয়
                    </button>
                @endif
            @endif
        </div>
        
        <div class="right-boxes">
            <div class="right-box">
                <i class="fas fa-shield-alt right-box-icon"></i>
                <div class="right-box-title">ঝুঁকি এড়িয়ে চলুন</div>
                <div class="right-box-value">{{ $riskAvoidance }}% ঝুঁকি কমেছে</div>
                <button class="check-btn" onclick="window.location=''">
                    <i class="fas fa-eye"></i>
                    এখন পরীক্ষা করুন
                </button>
            </div>
            <div class="right-box">
                <i class="fas fa-gift right-box-icon"></i>
               <div class="service-title">অনলাইন সেবা</div>
            <div class="service-count"> টি সেবা</div>
                <button class="check-btn" onclick="window.location=''">
                    <i class="fas fa-eye"></i>
                    এখন পরীক্ষা করুন
                </button>
            </div>
        </div>
    </section>

    <!-- VIP Products Section -->
 <section class="bottom-section">
    <a href="#" class="service-box">
        <div class="service-content">
            <i class="fas fa-stethoscope service-icon"></i>
            <div class="service-title">প্রাথমিক নির্ণয়</div>
        </div>
    </a>
    
  <a href="{{ \App\Models\SupportSetting::first()->telegram_link_2 ?? '#' }}" class="service-box" target="_blank">
    <div class="service-content">
        <i class="fas fa-laptop service-icon"></i>
        <div class="service-title">অনলাইন সেবা</div>
    </div>
</a>
    
    <a href="{{ route('about.show') }}" class="service-box">
        <div class="service-content">
            <i class="fas fa-info-circle service-icon"></i>
            <div class="service-title">সম্পর্কে জানুন</div>
        </div>
    </a>
</section>

<style>
    .bottom-section {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 15px;
        margin-top: 30px;
    }
    
    .service-box {
        background: #1a1a1a;
        border-radius: 12px;
        padding: 20px;
        text-align: center;
        transition: all 0.3s ease;
        text-decoration: none;
        color: white;
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        height: 100%;
    }
    
    .service-box:hover {
        transform: translateY(-5px);
        background: #2a2a2a;
        box-shadow: 0 8px 20px rgba(0,0,0,0.3);
    }
    
    .service-content {
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 10px;
    }
    
    .service-icon {
        font-size: 1.8rem;
        color: #3498db;
        margin-bottom: 5px;
    }
    
    .service-title {
        font-size: 1rem;
        font-weight: 600;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
        .bottom-section {
            grid-template-columns: 1fr;
        }
        
        .service-box {
            padding: 15px;
        }
    }
</style> 

<!-- Success Modal -->
<div class="modal-overlay" id="successModal">
    <div class="modal-content">
        <i class="fas fa-check-circle modal-icon success"></i>
        <h3 class="modal-title">বিনিয়োগ সফল!</h3>
        <p class="modal-message" id="successMessage"></p>
        <button class="modal-btn" id="successModalClose">ঠিক আছে</button>
    </div>
</div>

<!-- Error Modal -->
<div class="modal-overlay" id="errorModal">
    <div class="modal-content">
        <i class="fas fa-times-circle modal-icon error"></i>
        <h3 class="modal-title">ত্রুটি!</h3>
        <p class="modal-message" id="errorMessage"></p>
        <button class="modal-btn" id="errorModalClose">ঠিক আছে</button>
    </div>
</div>

<style>
    /* Main Container */
    .dashboard-container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 20px;
        color: #fff;
    }
    
    /* Header Styles */
    .dashboard-header {
        margin-bottom: 30px;
    }
    
    .header-content {
        background: #1a1a1a;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    
    .balance-section {
        display: flex;
        gap: 20px;
    }
    
    .balance-item {
        flex: 1;
        background: #2a2a2a;
        padding: 15px;
        border-radius: 8px;
    }
    
    .balance-label {
        font-size: 0.9rem;
        color: #bbb;
        margin-bottom: 5px;
    }
    
    .balance-value {
        font-size: 1.4rem;
        font-weight: 700;
        color: #27ae60;
    }
    
    /* Middle Section Styles */
    .middle-section {
        display: flex;
        flex-direction: column;
        gap: 20px;
        margin-bottom: 30px;
    }
    
    @media (min-width: 768px) {
        .middle-section {
            flex-direction: row;
        }
    }
    
    /* Feature Card Styles */
    .feature-card {
        flex: 2;
        background: #1a1a1a;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    
    .feature-header {
        display: flex;
        align-items: center;
        gap: 10px;
        position: relative;
        margin-bottom: 15px;
    }
    
    .feature-icon {
        color: #FFA500;
        font-size: 1.4rem;
    }
    
    .feature-title {
        font-size: 1.2rem;
        font-weight: 600;
    }
    
    .featured-badge {
        position: absolute;
        top: -10px;
        right: -10px;
        background: #FF5722;
        color: white;
        padding: 3px 10px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: bold;
    }
    
    .feature-product-name {
        font-size: 1.3rem;
        font-weight: 700;
        margin-bottom: 5px;
    }
    
    .feature-user-code {
        font-size: 0.9rem;
        color: #bbb;
        margin-bottom: 15px;
    }
    
    .feature-price-box {
        background: #2a2a2a;
        padding: 12px;
        border-radius: 8px;
        margin: 15px 0;
        display: flex;
        justify-content: space-between;
    }
    
    .price-label {
        font-weight: 600;
        color: #bbb;
    }
    
    .price-value {
        font-weight: 700;
        color: #27ae60;
        font-size: 1.2rem;
    }
    
    .feature-profit {
        padding: 10px;
        border-radius: 8px;
        text-align: center;
        margin: 15px 0;
        font-weight: 600;
    }
    
    .feature-profit.positive {
        background: rgba(46, 204, 113, 0.2);
        color: #27ae60;
    }
    
    .feature-profit.negative {
        background: rgba(231, 76, 60, 0.2);
        color: #ff6b6b;
    }
    
    .feature-investors {
        font-size: 0.9rem;
        color: #3498db;
        display: flex;
        align-items: center;
        gap: 5px;
        justify-content: center;
        margin: 15px 0;
    }
    
    .explore-btn {
        width: 100%;
        padding: 12px;
        background: linear-gradient(135deg, #3498db, #2ecc71);
        color: white;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        transition: all 0.3s ease;
        margin-top: 10px;
    }
    
    .explore-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(46, 204, 113, 0.3);
    }
    
    .explore-btn:disabled {
        background: #555;
        cursor: not-allowed;
    }
    
    /* Right Boxes Styles */
    .right-boxes {
        flex: 1;
        display: flex;
        flex-direction: column;
        gap: 20px;
    }
    
    .right-box {
        background: #1a1a1a;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        text-align: center;
    }
    
    .right-box-icon {
        font-size: 1.8rem;
        color: #3498db;
        margin-bottom: 10px;
    }
    
    .right-box-title {
        font-size: 1.1rem;
        font-weight: 600;
        margin-bottom: 5px;
    }
    
    .right-box-value {
        font-size: 1rem;
        color: #bbb;
        margin-bottom: 15px;
    }
    
    .check-btn {
        width: 100%;
        padding: 10px;
        background: #2a2a2a;
        color: #3498db;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        transition: all 0.3s ease;
    }
    
    .check-btn:hover {
        background: #333;
    }
    
    /* VIP Products Section */
    .vip-products-section {
        margin-bottom: 30px;
    }
    
    .section-header {
        margin-bottom: 20px;
        text-align: center;
    }
    
    .section-header h2 {
        font-size: 1.5rem;
        margin-bottom: 5px;
    }
    
    .section-header p {
        color: #bbb;
    }
    
    /* Tab Navigation */
    .tab-navigation {
        display: flex;
        gap: 10px;
        margin-bottom: 20px;
        overflow-x: auto;
        padding-bottom: 10px;
    }
    
    .tab-btn {
        background: #2a2a2a;
        border: none;
        border-radius: 20px;
        padding: 10px 20px;
        color: #fff;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 8px;
        cursor: pointer;
        white-space: nowrap;
    }
    
    .tab-btn.active {
        background: #3498db;
    }
    
    /* Products Container */
    .products-container {
        margin-bottom: 30px;
    }
    
    .tab-content {
        display: none;
    }
    
    .tab-content.active {
        display: block;
    }
    
    .products-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        gap: 20px;
    }
    
    /* Product Card Styles */
    .product-card {
        background: #1a1a1a;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        transition: all 0.3s ease;
    }
    
    .product-card:hover {
        transform: translateY(-5px);
    }
    
    .product-card.featured {
        border: 2px solid #FF5722;
    }
    
    .product-header {
        display: flex;
        justify-content: space-between;
        margin-bottom: 15px;
        position: relative;
    }
    
    .product-category {
        font-size: 0.9rem;
        color: #3498db;
    }
    
    .product-status {
        width: 10px;
        height: 10px;
        background: #27ae60;
        border-radius: 50%;
        align-self: center;
    }
    
    .featured-badge {
        position: absolute;
        top: -10px;
        right: -10px;
        background: #FF5722;
        color: white;
        padding: 3px 10px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: bold;
    }
    
    .product-name {
        font-size: 1.2rem;
        font-weight: 600;
        margin-bottom: 15px;
    }
    
    .product-details {
        margin-bottom: 20px;
    }
    
    .detail-item {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-bottom: 10px;
    }
    
    .detail-item i {
        color: #3498db;
    }
    
    .detail-content {
        flex: 1;
    }
    
    .detail-label {
        font-size: 0.8rem;
        color: #bbb;
        display: block;
    }
    
    .detail-value {
        font-weight: 600;
    }
    
    .invest-btn {
        width: 100%;
        padding: 12px;
        background: linear-gradient(135deg, #3498db, #2ecc71);
        color: white;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        transition: all 0.3s ease;
    }
    
    .invest-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(46, 204, 113, 0.3);
    }
    
    .invest-btn:disabled {
        background: #555;
        cursor: not-allowed;
    }
    
    .invested-badge {
        background: rgba(46, 204, 113, 0.2);
        color: #27ae60;
        padding: 10px;
        border-radius: 8px;
        text-align: center;
        font-weight: 600;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }
    
    /* Active Investments Section */
    .active-investments {
        margin-bottom: 30px;
    }
    
    .section-title {
        font-size: 1.5rem;
        margin-bottom: 20px;
        text-align: center;
    }
    
    .investments-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        gap: 20px;
    }
    
    .investment-card {
        background: #1a1a1a;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    
    .investment-header {
        display: flex;
        justify-content: space-between;
        margin-bottom: 15px;
    }
    
    .investment-header h3 {
        font-size: 1.2rem;
        font-weight: 600;
    }
    
    .days-remaining {
        background: #3498db;
        color: white;
        padding: 3px 10px;
        border-radius: 20px;
        font-size: 0.8rem;
        font-weight: 600;
    }
    
    .investment-details {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 15px;
    }
    
    .detail-row {
        display: flex;
        flex-direction: column;
    }
    
    .detail-row span {
        font-size: 0.8rem;
        color: #bbb;
    }
    
    .detail-row strong {
        font-weight: 600;
    }
    
    .no-investments {
        background: #1a1a1a;
        border-radius: 12px;
        padding: 30px;
        text-align: center;
        color: #bbb;
    }
    
    .no-investments i {
        font-size: 2rem;
        color: #3498db;
        margin-bottom: 15px;
    }
    
    /* Modal Styles */
    .modal-overlay {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0,0,0,0.7);
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 1000;
        opacity: 0;
        visibility: hidden;
        transition: all 0.3s ease;
    }
    
    .modal-overlay.active {
        opacity: 1;
        visibility: visible;
    }
    
    .modal-content {
        background: #1a1a1a;
        border-radius: 12px;
        padding: 30px;
        width: 90%;
        max-width: 400px;
        text-align: center;
        box-shadow: 0 10px 25px rgba(0,0,0,0.3);
    }
    
    .modal-icon {
        font-size: 3rem;
        margin-bottom: 15px;
    }
    
    .modal-icon.success {
        color: #27ae60;
    }
    
    .modal-icon.error {
        color: #e74c3c;
    }
    
    .modal-title {
        font-size: 1.3rem;
        margin-bottom: 10px;
    }
    
    .modal-message {
        margin-bottom: 20px;
        color: #bbb;
    }
    
    .modal-btn {
        background: #3498db;
        color: white;
        border: none;
        border-radius: 8px;
        padding: 10px 20px;
        font-weight: 600;
        cursor: pointer;
        width: 100%;
    }
    
    /* Responsive Adjustments */
    @media (max-width: 768px) {
        .balance-section {
            flex-direction: column;
        }
        
        .products-grid {
            grid-template-columns: 1fr;
        }
        
        .investment-details {
            grid-template-columns: 1fr;
        }
    }
</style>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab Functionality
    const tabBtns = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');
    
    tabBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            tabBtns.forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            
            tabContents.forEach(content => content.classList.remove('active'));
            const tabId = this.getAttribute('data-tab');
            document.getElementById(tabId).classList.add('active');
        });
    });
    
    // Investment Form Submission
    document.querySelectorAll('.investment-form').forEach(form => {
        form.addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const button = this.querySelector('button[type="submit"]');
            const originalText = button.innerHTML;
            button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> প্রসেসিং...';
            button.disabled = true;
            
            try {
                const response = await fetch(this.action, {
                    method: 'POST',
                    body: new FormData(this),
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json',
                    }
                });

                const data = await response.json();

                if (!response.ok) {
                    throw new Error(data.message || 'Investment failed');
                }

                if (data.success) {
                    // Show success message
                    document.getElementById('successMessage').textContent = data.message;
                    document.getElementById('successModal').classList.add('active');
                    
                    // Update balance display
                    document.querySelectorAll('.balance-value')[1].textContent = data.balance;
                    
                    // Reload after 2 seconds
                    setTimeout(() => {
                        window.location.reload();
                    }, 2000);
                } else {
                    throw new Error(data.message || 'Investment failed');
                }
            } catch (error) {
                console.error('Error:', error);
                document.getElementById('errorMessage').textContent = error.message;
                document.getElementById('errorModal').classList.add('active');
                
                button.innerHTML = originalText;
                button.disabled = false;
            }
        });
    });
    
    // Close modals
    document.getElementById('successModalClose').addEventListener('click', function() {
        document.getElementById('successModal').classList.remove('active');
    });
    
    document.getElementById('errorModalClose').addEventListener('click', function() {
        document.getElementById('errorModal').classList.remove('active');
    });
    
    // Close modals when clicking outside
    document.querySelectorAll('.modal-overlay').forEach(modal => {
        modal.addEventListener('click', function(e) {
            if (e.target === this) {
                this.classList.remove('active');
            }
        });
    });
});
</script>
@endsection