@extends('admin.admin_master')
@section('main')

<div style="margin-top: 70px;"></div>
@if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
@endif

<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">উত্তোলন তালিকা</h4>
            
            <div class="btn-group float-right">
                <a href="{{ route('admin.withdrawals.pending') }}" class="btn btn-sm btn-warning">বিচারাধীন</a>
                <a href="{{ route('admin.withdrawals.approved') }}" class="btn btn-sm btn-success">অনুমোদিত</a>
                <a href="{{ route('admin.withdrawals.rejected') }}" class="btn btn-sm btn-danger">প্রত্যাখ্যাত</a>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
              <table class="table table-bordered">
    <thead>
        <tr>
            <th>আইডি</th>
            <th>ব্যবহারকারী</th>
            <th>পদ্ধতি</th>
          
            <th>নেট পরিমাণ</th>
            <th>ওয়ালেট নম্বর</th>
            <th>স্ট্যাটাস</th>
            <th>তারিখ</th>
            <th>ক্রিয়া</th>
        </tr>
    </thead>
    <tbody>
        @foreach($withdrawals as $withdrawal)
        <tr>
            <td>{{ $withdrawal->id }}</td>
            <td>{{ $withdrawal->user->name ?? 'Null User' }}</td>
            <td>{{ $withdrawal->paymentMethod->name ?? 'N/A' }}</td>
          
            <td>{{ number_format($withdrawal->amount, 2) }} ৳</td>
            <td>{{ $withdrawal->sender_number }}</td>
            <td>
                <span class="badge badge-{{ 
                    $withdrawal->status == 'approved' ? 'success' : 
                    ($withdrawal->status == 'rejected' ? 'danger' : 'warning') 
                }}">
                    @if($withdrawal->status == 'approved') অনুমোদিত
                    @elseif($withdrawal->status == 'rejected') প্রত্যাখ্যাত
                    @else বিচারাধীন
                    @endif
                </span>
            </td>
            <td>{{ $withdrawal->created_at->format('d M Y h:i A') }}</td>
              <td>
                                @if($withdrawal->status == 'pending')
                                <div class="btn-group">
                                    <form action="{{ route('admin.withdrawals.approve', $withdrawal) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-success">অনুমোদন</button>
                                    </form>
                                    <form action="{{ route('admin.withdrawals.reject', $withdrawal) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-danger">প্রত্যাখ্যান</button>
                                    </form>
                                </div>
                                @elseif($withdrawal->status == 'approved')
                                <button class="btn btn-sm btn-info" data-toggle="modal" data-target="#processModal{{ $withdrawal->id }}">
                                    প্রক্রিয়া করুন
                                </button>
                                @endif
                                
                                <form action="{{ route('admin.withdrawals.destroy', $withdrawal) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('আপনি কি নিশ্চিতভাবে এই উত্তোলন ডিলিট করতে চান?')">
                                        ডিলিট
                                    </button>
                                </form>
                                
                                <!-- প্রক্রিয়া মোডাল -->
                                <div class="modal fade" id="processModal{{ $withdrawal->id }}" tabindex="-1" role="dialog">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <form action="{{ route('admin.withdrawals.process', $withdrawal) }}" method="POST">
                                                @csrf
                                                <div class="modal-header">
                                                    <h5 class="modal-title">উত্তোলন প্রক্রিয়া সম্পন্ন করুন</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="form-group">
                                                        <label>লেনদেন আইডি</label>
                                                        <input type="text" name="transaction_id" class="form-control" required placeholder="লেনদেন আইডি লিখুন">
                                                    </div>
                                                    <div class="form-group">
                                                        <label>নোটস</label>
                                                        <textarea name="notes" class="form-control" placeholder="প্রয়োজনীয় নোটস লিখুন"></textarea>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">বন্ধ করুন</button>
                                                    <button type="submit" class="btn btn-primary">প্রক্রিয়া সম্পন্ন করুন</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </td>
        </tr>
        @endforeach
    </tbody>
</table>
            </div>
            {{ $withdrawals->links() }}
        </div>
    </div>
</div>

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Alert স্বয়ংক্রিয়ভাবে বন্ধ
        setTimeout(function() {
            $('.alert').fadeOut('slow');
        }, 5000);
        
        // ডিলিট কনফার্মেশন
        $('form[action*="withdrawals"]').on('submit', function(e) {
            const action = $(this).attr('action');
            if (action.includes('destroy')) {
                return confirm('আপনি কি নিশ্চিতভাবে এই উত্তোলন ডিলিট করতে চান? এই কাজটি পূর্বাবস্থায় ফেরানো যাবে না।');
            }
            return true;
        });
    });
</script>
@endsection

@endsection