@extends('admin.admin_master')
@section('main')

<div class="card shadow-lg rounded-3">
    <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center py-3">
        <h5 class="mb-0">
            <i class="fas fa-gem me-2"></i> ভিআইপি পণ্য ব্যবস্থাপনা
        </h5>
        <a href="{{ route('admin.vip-products.create') }}" class="btn btn-light rounded-pill">
            <i class="fas fa-plus me-1"></i> নতুন পণ্য যোগ করুন
        </a>
    </div>
    
    <div class="card-body">
        @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i> {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <div class="table-responsive">
            <table class="table table-hover table-bordered">
                <thead class="table-light">
                    <tr>
                        <th class="text-center">#</th>
                        <th>ক্যাটাগরি</th>
                        <th>বিনিয়োগ টুল</th>
                        <th class="text-end">মূল্য (৳)</th>
                        <th class="text-center">সময়কাল (দিন)</th>
                        <th class="text-end">মোট লাভ সীমা (৳)</th>
                        <th class="text-end">ব্যবহারকারী প্রতি আয় (৳)</th>
                        <th class="text-center">অবস্থা</th>
                        <th class="text-center">কার্যক্রম</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($products as $product)
                    <tr>
                        <td class="text-center">{{ $loop->iteration }}</td>
                        <td>
                            @if($product->category)
                                <span class="badge bg-primary rounded-pill px-3 py-1">
                                    {{ $product->category->display_name }}
                                </span>
                            @else
                                <span class="badge bg-danger rounded-pill px-3 py-1">
                                    ক্যাটাগরি নেই
                                </span>
                            @endif
                        </td>
                        <td class="fw-bold">{{ $product->investment_tool }}</td>
                        <td class="text-end">{{ number_format($product->price, 2) }}</td>
                        <td class="text-center">{{ $product->duration_days }}</td>
                        <td class="text-end">{{ number_format($product->total_profit_limit, 2) }}</td>
                        <td class="text-end">{{ number_format($product->earnings_per_user, 2) }}</td>
                        <td class="text-center">
                            @if($product->is_active)
                                <span class="badge bg-success">সক্রিয়</span>
                            @else
                                <span class="badge bg-secondary">নিষ্ক্রিয়</span>
                            @endif
                        </td>
                        <td class="text-center">
                            <div class="btn-group" role="group">
                                <a href="{{ route('admin.vip-products.edit', $product->id) }}" 
                                   class="btn btn-sm btn-warning rounded-start-pill" 
                                   title="সম্পাদনা">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('admin.vip-products.destroy', $product->id) }}" method="POST">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                            class="btn btn-sm btn-danger rounded-end-pill"
                                            onclick="return confirm('আপনি কি এই পণ্যটি মুছে ফেলতে নিশ্চিত?')"
                                            title="মুছুন">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="text-center py-4">
                            <i class="fas fa-box-open fa-2x text-muted mb-3"></i>
                            <h5 class="text-muted">কোন ভিআইপি পণ্য পাওয়া যায়নি</h5>
                            <a href="{{ route('admin.vip-products.create') }}" class="btn btn-primary mt-2">
                                <i class="fas fa-plus me-1"></i> প্রথম পণ্য তৈরি করুন
                            </a>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection

@push('styles')
<style>
    .table th {
        white-space: nowrap;
    }
    .badge {
        font-size: 0.85em;
    }
    .btn-group .btn {
        padding: 0.25rem 0.75rem;
    }
    .rounded-start-pill {
        border-top-right-radius: 0 !important;
        border-bottom-right-radius: 0 !important;
    }
    .rounded-end-pill {
        border-top-left-radius: 0 !important;
        border-bottom-left-radius: 0 !important;
    }
</style>
@endpush