@extends('admin.admin_master')

@section('main')
<div class="container-fluid">
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">
                <i class="fas fa-{{ isset($product) ? 'edit' : 'plus-circle' }} me-2"></i>
                {{ isset($product) ? 'ভিআইপি পণ্য সম্পাদনা' : 'নতুন ভিআইপি পণ্য তৈরি' }}
            </h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="{{ route('admin.dashboard') }}">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.vip-products.index') }}">ভিআইপি পণ্য</a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="#">{{ isset($product) ? 'সম্পাদনা' : 'তৈরি করুন' }}</a>
                </li>
            </ul>
        </div>

        <div class="row">
            <div class="col-md-12">
                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-exclamation-triangle fs-3 me-2"></i>
                            <div>
                                <h5 class="alert-heading mb-1">ত্রুটি!</h5>
                                <ul class="mb-0 ps-3">
                                    @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                <div class="card">
                    <div class="card-header bg-primary">
                        <div class="card-title text-white">
                            <i class="fas fa-crown me-2"></i>
                            ভিআইপি পণ্যের তথ্য
                        </div>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ isset($product) ? route('admin.vip-products.update', $product->id) : route('admin.vip-products.store') }}">
                            @csrf
                            @if(isset($product)) @method('PUT') @endif

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label required">ভিআইপি ক্যাটাগরি</label>
                                    <select name="category_id" class="form-select select2 @error('category_id') is-invalid @enderror" required>
                                        <option value="">ক্যাটাগরি নির্বাচন করুন</option>
                                        @foreach($categories as $category)
                                            <option value="{{ $category->id }}" 
                                                {{ old('category_id', $product->category_id ?? '') == $category->id ? 'selected' : '' }}>
                                                {{ $category->display_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('category_id')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label required">বিনিয়োগ টুল</label>
                                    <input type="text" class="form-control @error('investment_tool') is-invalid @enderror" 
                                           name="investment_tool" value="{{ old('investment_tool', $product->investment_tool ?? '') }}" required>
                                    @error('investment_tool')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <label class="form-label required">পণ্যের মূল্য (৳)</label>
                                    <div class="input-group">
                                        <input type="number" step="0.01" class="form-control @error('price') is-invalid @enderror" 
                                               name="price" value="{{ old('price', $product->price ?? '') }}" required>
                                        <span class="input-group-text">৳</span>
                                    </div>
                                    @error('price')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="col-md-4">
                                    <label class="form-label required">সময়কাল (দিন)</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control @error('duration_days') is-invalid @enderror" 
                                               name="duration_days" value="{{ old('duration_days', $product->duration_days ?? '') }}" required>
                                        <span class="input-group-text">দিন</span>
                                    </div>
                                    @error('duration_days')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                
                                
                                
                             
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <label class="form-label required">মোট লাভ সীমা (৳)</label>
                                    <div class="input-group">
                                        <input type="number" step="0.01" class="form-control @error('total_profit_limit') is-invalid @enderror" 
                                               name="total_profit_limit" value="{{ old('total_profit_limit', $product->total_profit_limit ?? '') }}" required>
                                        <span class="input-group-text">৳</span>
                                    </div>
                                    @error('total_profit_limit')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="col-md-4">
                                    <label class="form-label required">ব্যবহারকারী প্রতি আয় (৳)</label>
                                    <div class="input-group">
                                        <input type="number" step="0.01" class="form-control @error('earnings_per_user') is-invalid @enderror" 
                                               name="earnings_per_user" value="{{ old('earnings_per_user', $product->earnings_per_user ?? 0) }}" required>
                                        <span class="input-group-text">৳</span>
                                    </div>
                                    @error('earnings_per_user')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="col-md-4">
                                    <label class="form-label required">দৈনিক শেয়ার অনুপাত (%)</label>
                                    <div class="input-group">
                                        <input type="number" step="0.01" class="form-control @error('daily_share_ratio') is-invalid @enderror" 
                                               name="daily_share_ratio" value="{{ old('daily_share_ratio', $product->daily_share_ratio ?? '') }}" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                    @error('daily_share_ratio')
                                        <div class="invalid-feedback d-block">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="is_active" value="1" 
                                           id="is_active" {{ old('is_active', $product->is_active ?? true) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_active">সক্রিয় পণ্য</label>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">বৈশিষ্ট্য</label>
                                <textarea class="form-control @error('features') is-invalid @enderror" 
                                          name="features" rows="4" placeholder="প্রতিটি বৈশিষ্ট্য নতুন লাইনে লিখুন">{{ old('features', $product->features ?? '') }}</textarea>
                                @error('features')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="d-flex justify-content-between border-top pt-3">
                                <a href="{{ route('admin.vip-products.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-arrow-circle-left me-1"></i> তালিকায় ফিরে যান
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i> {{ isset($product) ? 'আপডেট করুন' : 'সংরক্ষণ করুন' }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    .required:after {
        content: " *";
        color: red;
    }
    .card-header {
        border-radius: 0.5rem 0.5rem 0 0 !important;
    }
    .form-control, .form-select, .select2-selection {
        height: calc(2.25rem + 8px);
        border-radius: 0.375rem;
        border: 1px solid #ced4da;
    }
    .form-control:focus, .form-select:focus, .select2-selection:focus {
        border-color: #4e73df;
        box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
    }
    .form-check-input {
        width: 2.5em;
        height: 1.25em;
    }
    .form-check-input:checked {
        background-color: #4e73df;
        border-color: #4e73df;
    }
    .invalid-feedback.d-block {
        display: block;
        margin-top: 0.25rem;
        font-size: 0.875em;
        color: #dc3545;
    }
    .card {
        border-radius: 0.5rem;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.1);
        border: none;
    }
    .btn {
        border-radius: 0.375rem;
        padding: 0.5rem 1.25rem;
    }
    textarea.form-control {
        min-height: 100px;
    }
    .fa-crown {
        color: gold;
        text-shadow: 1px 1px 2px rgba(0,0,0,0.5);
    }
</style>
@endpush

@push('scripts')
<script>
    $(document).ready(function() {
        $('.select2').select2({
            theme: 'bootstrap4',
            width: '100%'
        });
    });
</script>
@endpush
@endsection