@extends('admin.admin_master')
@section('main')

<div class="card">
    <div class="card-header">
        <h4 class="card-title">ভিআইপি আয় প্রসেসিং</h4>
    </div>
    <div class="card-body">
        <div class="mb-4">
            <a href="{{ route('admin.vip.pending-earnings') }}" class="btn btn-info">
                <i class="fas fa-list"></i> পেন্ডিং আয় দেখুন
            </a>
        </div>
        
        <form id="processEarningsForm">
            @csrf
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-sync-alt"></i> ভিআইপি আয় ম্যানুয়ালি প্রসেস করুন
            </button>
        </form>

        <div id="processResult" class="mt-3"></div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#processEarningsForm').on('submit', function(e) {
        e.preventDefault();
        
        $.ajax({
            url: "{{ route('admin.vip.process-earnings') }}",
            type: "POST",
            data: $(this).serialize(),
            beforeSend: function() {
                $('#processResult').html('<div class="alert alert-info">প্রসেসিং চলছে...</div>');
            },
            success: function(response) {
                let successHtml = `
                    <div class="alert alert-success">
                        <h5>সফল!</h5>
                        <p>${response.message}</p>
                        <p>মোট প্রসেস করা ইনভেস্টমেন্ট: ${response.processed}</p>
                    </div>
                `;
                
                let errorHtml = `
                    <div class="alert alert-danger">
                        <h5>ত্রুটি!</h5>
                        <p>${response.message}</p>
                    </div>
                `;
                
                $('#processResult').html(response.success ? successHtml : errorHtml);
                
                // ৩ সেকেন্ড পর অ্যালার্ট আপনা-আপনি হারিয়ে যাবে
                setTimeout(() => {
                    $('#processResult').html('');
                }, 3000);
            },
            error: function(xhr) {
                $('#processResult').html(`
                    <div class="alert alert-danger">
                        <h5>ত্রুটি!</h5>
                        <p>সার্ভার থেকে কোনো রেসপন্স পাওয়া যায়নি</p>
                    </div>
                `);
                console.error(xhr.responseText);
            }
        });
    });
});
</script>
@endsection