@extends('admin.admin_master')
@section('main')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif

            <div class="card">
                <div class="card-header">
                    <h4>Support Settings</h4>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.support.update') }}">
                        @csrf
                        <div class="form-group mb-3">
                            <label for="telegram_link">Support team</label>
                            <input type="url" class="form-control" id="telegram_link" name="telegram_link" 
                                   value="{{ $support->telegram_link }}" required>
                        </div>

                          <div class="form-group mb-3">
                            <label for="telegram_link">অনলাইন সেবা</label>
                            <input type="url" class="form-control" id="telegram_link_2" name="telegram_link_2" 
                                   value="{{ $support->telegram_link_2 }}" required>
                        </div>


                        <div class="form-group mb-3">
                            <label for="support_text">Support Text</label>
                            <textarea class="form-control" id="support_text" name="support_text" 
                                      rows="3" required>{{ $support->support_text }}</textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Alert টি 5 সেকেন্ড পর অটোমেটিক বন্ধ হয়ে যাবে
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
</script>
@endsection