@extends('admin.admin_master')
@section('main')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">SEO Management</h3>
        </div>
        <div class="card-body">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Page/Model</th>
                        <th>Meta Title</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($seoData as $seo)
                    <tr>
                        <td>{{ $seo->id }}</td>
                        <td>
                            @if($seo->metaable)
                                {{ class_basename($seo->metaable) }}: {{ $seo->metaable->title ?? $seo->metaable->name }}
                            @else
                                N/A
                            @endif
                        </td>
                        <td>{{ $seo->meta_title }}</td>
                        <td>
                            <a href="{{ route('admin.seo.edit', $seo->id) }}" class="btn btn-sm btn-primary">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            {{ $seoData->links() }}
        </div>
    </div>
</div>
@endsection