@extends('admin.admin_master')
@section('main')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Edit SEO Data</h3>
        </div>
        <form action="{{ route('admin.seo.update', $seo->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="card-body">
                <div class="form-group">
                    <label>Meta Title</label>
                    <input type="text" name="meta_title" class="form-control" value="{{ $seo->meta_title }}">
                    <small class="text-muted">Recommended: 50-60 characters</small>
                </div>
                
                <div class="form-group">
                    <label>Meta Description</label>
                    <textarea name="meta_description" class="form-control" rows="3">{{ $seo->meta_description }}</textarea>
                    <small class="text-muted">Recommended: 150-160 characters</small>
                </div>
                
                <div class="form-group">
                    <label>Meta Keywords</label>
                    <input type="text" name="meta_keywords" class="form-control" value="{{ $seo->meta_keywords }}">
                    <small class="text-muted">Comma separated keywords</small>
                </div>
                
                <div class="form-group">
                    <label>OG Title</label>
                    <input type="text" name="og_title" class="form-control" value="{{ $seo->og_title }}">
                </div>
                
                <div class="form-group">
                    <label>OG Description</label>
                    <textarea name="og_description" class="form-control" rows="3">{{ $seo->og_description }}</textarea>
                </div>
                
                <div class="form-group">
                    <label>OG Image</label>
                    <input type="file" name="og_image" class="form-control-file">
                    @if($seo->og_image)
                        <img src="{{ $seo->og_image }}" height="100" class="mt-2">
                    @endif
                </div>
                
                <div class="form-group">
                    <label>Canonical URL</label>
                    <input type="url" name="canonical_url" class="form-control" value="{{ $seo->canonical_url }}">
                </div>
            </div>
            <div class="card-footer">
                <button type="submit" class="btn btn-primary">Update SEO</button>
                <a href="{{ route('admin.seo.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection