@extends('admin.admin_master')

@section('main')
<div class="container mt-5">
    <h2 class="text-center">Admin Profile</h2>

    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif

    <form action="{{ route('admin.profile.update') }}" method="POST" enctype="multipart/form-data" class="border p-4 rounded shadow">
        @csrf

        <div class="form-group mb-3">
            <label for="name">Name</label>
            <input type="text" name="name" id="name" value="{{ old('name', $admin->name) }}" class="form-control" required>
            @error('name')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group mb-3">
            <label for="email">Email</label>
            <input type="email" name="email" id="email" value="{{ old('email', $admin->email) }}" class="form-control" required>
            @error('email')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>

       


        <hr>
        <h5 class="mt-4">Change Password</h5>
        <div class="form-group mb-3">
            <label for="current_password">Current Password</label>
            <input type="password" name="current_password" id="current_password" class="form-control">
            @error('current_password')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group mb-3">
            <label for="new_password">New Password</label>
            <input type="password" name="new_password" id="new_password" class="form-control">
            @error('new_password')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group mb-3">
            <label for="new_password_confirmation">Confirm New Password</label>
            <input type="password" name="new_password_confirmation" id="new_password_confirmation" class="form-control">
            @error('new_password_confirmation')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>

        <button type="submit" class="btn btn-primary">Update Profile</button>
    </form>
</div>

<style>
    .container {
        max-width: 600px; /* Set a max width for the form */
    }
    .form-control {
        border-radius: 0.25rem; /* Slightly rounded corners */
    }
    .btn-primary {
        background-color: #007bff; /* Primary button color */
        border-color: #007bff;
    }
    .btn-primary:hover {
        background-color: #0056b3; /* Darker blue on hover */
        border-color: #0056b3;
    }
</style>
@endsection
