@extends('admin.admin_master')

@section('main')
<div class="container mt-5">
    <h2 class="text-center mb-4">Admin Profile</h2>

    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif

    <form action="{{ route('admin.profile.update') }}" method="POST" enctype="multipart/form-data" class="border p-4 rounded shadow-lg">
        @csrf

        <div class="form-group mb-3">
            <label for="name" class="form-label fw-semibold">Name</label>
            <input type="text" name="name" id="name" value="{{ old('name', $admin->name) }}" class="form-control" required>
            @error('name')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group mb-3">
            <label for="email" class="form-label fw-semibold">Email</label>
            <input type="email" name="email" id="email" value="{{ old('email', $admin->email) }}" class="form-control" required>
            @error('email')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group mb-3">
            <label for="image" class="form-label fw-semibold">Profile Image</label>
            <input type="file" name="image" id="image" class="form-control">
            <div class="mt-3">
            <img src="{{ Auth::guard('admin')->user()->image ? asset(Auth::guard('admin')->user()->image) : asset('profile_images/no_images.jpg') }}" 
     class="avatar img-fluid rounded-circle border" 
     alt="{{ $admin->name }}" 
     width="100">

            </div>
        </div>

        <hr class="my-4">

        <h5 class="fw-bold">Change Password</h5>
        <div class="form-group mb-3">
            <label for="current_password" class="form-label fw-semibold">Current Password</label>
            <input type="password" name="current_password" id="current_password" class="form-control">
            @error('current_password')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group mb-3">
            <label for="new_password" class="form-label fw-semibold">New Password</label>
            <input type="password" name="new_password" id="new_password" class="form-control">
            @error('new_password')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group mb-3">
            <label for="new_password_confirmation" class="form-label fw-semibold">Confirm New Password</label>
            <input type="password" name="new_password_confirmation" id="new_password_confirmation" class="form-control">
            @error('new_password_confirmation')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>

        <button type="submit" class="btn btn-primary w-100 mt-3">Update Profile</button>
    </form>
</div>

<style>
    .container {
        max-width: 600px; /* Set a max width for the form */
    }
    .form-control {
        border-radius: 0.25rem; /* Slightly rounded corners */
        box-shadow: 0 0 5px rgba(0, 0, 0, 0.1); /* Light shadow */
    }
    .btn-primary {
        background-color: #007bff;
        border-color: #007bff;
        border-radius: 0.25rem;
    }
    .btn-primary:hover {
        background-color: #0056b3;
        border-color: #0056b3;
    }
    .fw-semibold {
        font-weight: 500; /* Medium font-weight for labels */
    }
    hr.my-4 {
        border-top: 1px solid #ddd; /* Light divider line */
    }
    img.avatar {
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); /* Add a soft shadow to the avatar */
    }
</style>
@endsection
