@extends('admin.admin_master')
@section('main')
<div class="container-fluid">
    <div class="page-header">
        <div class="row align-items-center">
            <div class="col">
                <h4>
                    <i class="fas fa-edit me-2"></i>
                    Edit Payment Method
                </h4>
            </div>
            <div class="col-auto">
                <a href="{{ route('admin.payment-methods') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Back to List
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card">
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.payment-methods.update', $method->id) }}" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Method Name</label>
                                <input type="text" class="form-control" name="name" 
                                       value="{{ old('name', $method->name) }}" required>
                                @error('name')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Account Number</label>
                                <input type="text" class="form-control" name="account_number" 
                                       value="{{ old('account_number', $method->account_number) }}" required>
                                @error('account_number')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" rows="3" required>{{ old('description', $method->description) }}</textarea>
                            @error('description')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Current Icon</label>
                            @if($method->icon)
                                <div class="mb-2">
                                    <img src="{{ asset($method->icon) }}" alt="{{ $method->name }}" 
                                         style="width: 60px; height: 60px; object-fit: contain;">
                                    <a href="#" class="btn btn-sm btn-danger ms-2" id="removeIcon">
                                        <i class="fas fa-trash"></i> Remove
                                    </a>
                                    <input type="hidden" name="remove_icon" id="removeIconInput" value="0">
                                </div>
                            @else
                                <p class="text-muted">No icon uploaded</p>
                            @endif
                            
                            <label class="form-label">Change Icon (Optional)</label>
                            <input type="file" class="form-control" name="icon" accept="image/*">
                            <small class="text-muted">Recommended: 100x100px PNG with transparent background</small>
                            @error('icon')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3 form-check form-switch">
                            <input type="checkbox" class="form-check-input" name="is_active" 
                                   id="is_active" {{ $method->is_active ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">Active</label>
                        </div>

                        <div class="d-flex justify-content-between mt-4">
                            <button type="button" class="btn btn-danger delete-method" 
                                    data-id="{{ $method->id }}">
                                <i class="fas fa-trash me-1"></i> Delete Method
                            </button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i> Update Method
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this payment method? This action cannot be undone.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Remove icon functionality
    $('#removeIcon').click(function(e) {
        e.preventDefault();
        $(this).addClass('d-none');
        $('#removeIconInput').val('1');
        $('input[name="icon"]').val('');
    });

    // Delete method
    $('.delete-method').click(function() {
        let methodId = $(this).data('id');
        $('#deleteForm').attr('action', "{{ route('admin.payment-methods.destroy', '') }}/" + methodId);
        $('#deleteModal').modal('show');
    });
});
</script>
@endpush