@extends('admin.admin_master')
@section('main')
<div class="container mt-5">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h3 class="mb-0">Website Settings</h3>
        </div>
        <div class="card-body">
            <form action="{{ route('settings.update') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="mb-3">
                    <label for="site_name" class="form-label">Site Name</label>
                    <input type="text" class="form-control" id="site_name" name="site_name" value="{{ $settings->site_name ?? '' }}" placeholder="Enter site name">
                </div>

                <div class="mb-3">
                    <label for="logo" class="form-label">Logo</label>
                    <input type="file" class="form-control" id="logo" name="logo">
                    @if($settings && $settings->logo)
                    <div class="mt-2">
                        <img src="{{ asset('home/' . $settings->logo) }}" alt="Logo" width="100" class="img-thumbnail">
                    </div>
                @endif

                </div>

                <div class="mb-3">
                    <label for="seo_title" class="form-label">SEO Title</label>
                    <input type="text" class="form-control" id="seo_title" name="seo_title" value="{{ $settings->seo_title ?? '' }}" placeholder="Enter SEO title">
                </div>

                <div class="mb-3">
                    <label for="seo_description" class="form-label">SEO Description</label>
                    <textarea class="form-control" id="seo_description" name="seo_description" rows="4" placeholder="Enter SEO description">{{ $settings->seo_description ?? '' }}</textarea>
                </div>

                <button type="submit" class="btn btn-success">Save Settings</button>
            </form>
        </div>
    </div>
</div>
@endsection
