@extends('admin.admin_master')
@section('main')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card shadow-lg">
                <div class="card-header bg-primary text-white">
                    <h4><i class="fas fa-percentage"></i> কমিশন নীতি সম্পাদনা</h4>
                </div>
                <div class="card-body">
                    <!-- সফলতা/ত্রুটি বার্তা -->
                    @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show">
                        {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert">
                            <span>&times;</span>
                        </button>
                    </div>
                    @endif

                    @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show">
                        {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert">
                            <span>&times;</span>
                        </button>
                    </div>
                    @endif

                    <form action="{{ route('admin.commissions.update') }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="form-group">
                            <label for="description">কমিশন নীতির বিবরণ</label>
                            <textarea name="description" id="description" class="form-control" 
                                    rows="15" required>{{ old('description', $commission->description ?? '') }}</textarea>
                            @error('description')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group text-right">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> আপডেট করুন
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
// 5 সেকেন্ড পর অ্যালার্ট স্বয়ংক্রিয়ভাবে বন্ধ
$(document).ready(function(){
    setTimeout(function(){
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
@endsection