<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
              $table->foreignId('user_id')->constrained();
    $table->enum('type', ['deposit', 'withdraw']);
    $table->decimal('amount', 10, 2);
    $table->string('method')->nullable(); // bkash, nagad, bank etc.
    $table->string('transaction_id')->nullable();
    $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
