<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::table('vip_products', function (Blueprint $table) {
            // Check if the wrong column exists
            if (Schema::hasColumn('vip_products', 'vip_category_id')) {
                // Drop the wrong foreign key if exists
                $table->dropForeign(['vip_category_id']);
                // Rename the column
                $table->renameColumn('vip_category_id', 'category_id');
                // Add the correct foreign key
                $table->foreign('category_id')->references('id')->on('vip_categories');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
         Schema::table('vip_products', function (Blueprint $table) {
            if (Schema::hasColumn('vip_products', 'category_id')) {
                $table->dropForeign(['category_id']);
                $table->renameColumn('category_id', 'vip_category_id');
                $table->foreign('vip_category_id')->references('id')->on('vip_categories');
            }
        });
    }
};
