<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vip_products', function (Blueprint $table) {
            $table->id();
              $table->foreignId('category_id')->constrained('vip_categories');
                $table->string('investment_tool'); 
                $table->decimal('price', 10, 2);
                $table->integer('invested_users')->default(0);
                $table->decimal('earnings_per_user', 10, 2);
                $table->text('features')->nullable();
                $table->boolean('is_featured')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vip_products');
    }
};
