<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VipProduct extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'investment_tool',
        'price',
        'invested_users',
        'earnings_per_user',
        'features',
        'user_limit',
        'is_featured',
        'daily_share_ratio', 
        'daily_share_amount', 
        'duration_days',
        'total_profit_limit',
        'is_active'
    ];

  // App\Models\VipProduct.php

public function isAvailableFor(User $user)
{
    // শুধুমাত্র চেক করবে ব্যবহারকারী এই পণ্য কিনেছে কিনা (মেয়াদ শেষ হলেও)
    return !$user->vipInvestments()
        ->where('vip_product_id', $this->id)
        ->exists();
}

    public function category(): BelongsTo
    {
        return $this->belongsTo(VipCategory::class, 'category_id');
    }

    public function investments()
    {
        return $this->hasMany(UserVipInvestment::class);
    }

    public function incrementInvestedUsers()
    {
        $this->increment('invested_users');
    }



public function scopeActive($query)
{
    return $query->where('is_active', true); // expires_at চেক রিমুভ করুন
}

    public function scopeFeatured($query)
    {
        return $query->where('is_featured', true);
    }
}