<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class VipCategory extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'display_name', 'description', 'is_active', 'icon'];

    public function products(): HasMany
    {
        return $this->hasMany(VipProduct::class, 'category_id');
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', 1);
    }
}