<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = ['key', 'value', 'type', 'group'];

    public static function getValue($key, $default = null)
    {
        $setting = static::where('key', $key)->first();
        return $setting ? $setting->value : $default;
    }

    public static function getGroup($group)
    {
        return static::where('group', $group)->get();
    }

    // Add this method to ensure default settings exist
    public static function ensureSettingsExist()
    {
        $defaultSettings = [
            'site_name' => ['value' => 'My Awesome Site', 'type' => 'text', 'group' => 'general'],
            'site_logo' => ['value' => '/images/logo.png', 'type' => 'image', 'group' => 'general'],
            'site_favicon' => ['value' => '/images/favicon.ico', 'type' => 'image', 'group' => 'general'],
            'contact_email' => ['value' => 'contact@example.com', 'type' => 'email', 'group' => 'contact'],
            'contact_phone' => ['value' => '+1234567890', 'type' => 'text', 'group' => 'contact'],
        ];

        foreach ($defaultSettings as $key => $data) {
            self::firstOrCreate(
                ['key' => $key],
                $data
            );
        }
    }
}