<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\VipCategory;
use App\Models\VipProduct;
use Illuminate\Support\Facades\Auth;

class InvestmentController extends Controller
{
   public function index()
{
    if (!Auth::check()) {
        return redirect()->route('login');
    }

    $user = Auth::user();
    
    $categories = VipCategory::active()
                    ->with(['products' => function($query) use ($user) {
                        $query->where('is_active', true)
                              ->orderBy('is_featured', 'desc')
                              ->orderBy('price');
                    }])
                    ->get();

    return view('user.investments.index', [
        'categories' => $categories,
        'activeInvestments' => $user->activeVipInvestments()->with('product')->get(),
        'totalDailyEarnings' => $user->totalVipEarnings()
    ]);
}
}