<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class ErrorController extends Controller
{
    public function notFound()
    {
        return view('errors');
    }
    
    public function adminNotFound()
    {
        return view('admin.errors.404');
    }

    public function handleFallback()
    {
        if (request()->is('admin/*')) {
            return $this->adminNotFound();
        }
        return $this->notFound();
    }
}