<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Illuminate\View\View;

class RegisteredUserController extends Controller
{
    /**
     * রেজিস্ট্রেশন পেজ দেখাবে
     */
    public function create(Request $request): View
    {
        $refCode = $request->query('ref');
        return view('auth.register', ['refCode' => $refCode]);
    }

    /**
     * রেজিস্ট্রেশন রিকুয়েস্ট হ্যান্ডেল করবে
     */
  // RegisteredUserController.php এর store মেথডে নিচের পরিবর্তনগুলো করুন

public function store(Request $request): RedirectResponse
{
    // ভ্যালিডেশন রুলস
    $request->validate([
        'phone' => ['required', 'string', 'max:20', 'unique:users,phone'],
        'password' => ['required', 'confirmed', Rules\Password::defaults()],
        'referral_code' => ['nullable', 'exists:users,referral_code']
    ], [
        'phone.unique' => 'এই ফোন নম্বরটি ইতিমধ্যে রেজিস্টার্ড। দয়া করে অন্য নম্বর ব্যবহার করুন অথবা লগইন করুন।',
        'password.confirmed' => 'পাসওয়ার্ড কনফার্মেশন মেলেনি।',
    ]);

    // রেফারেল কোড হ্যান্ডেলিং
    $refCode = $request->referral_code ?? $request->query('ref');
    $referred_by = null;
    
    if ($refCode) {
        $referrer = User::where('referral_code', $refCode)->first();
        if ($referrer) {
            $referred_by = $referrer->id;
        }
    }

    // নতুন ইউজার ক্রিয়েট করছি
    $user = User::create([
        'phone' => $request->phone,
        'password' => Hash::make($request->password),
        'referral_code' => User::generateReferralCode(),
        'referred_by' => $referred_by,
        'balance' => 25.00, // এখানে ২৫ টাকা যোগ করা হচ্ছে
    ]);

    // রেজিস্ট্রেশন বোনাস ট্রানজেকশন তৈরি করুন
    \App\Models\Transaction::create([
        'user_id' => $user->id,
        'type' => 'signup_bonus',
        'amount' => 25.00,
        'method' => 'system',
        'status' => 'approved',
        'transaction_id' => 'BONUS-'.uniqid(),
        'notes' => 'Signup bonus credited'
    ]);

    // রেজিস্ট্রেশন ইভেন্ট ফায়ার করছি
    event(new Registered($user));

    // ইউজারকে লগইন করাচ্ছি
    Auth::login($user);

    // HOME পেজে রিডাইরেক্ট করছি
    return redirect(RouteServiceProvider::HOME);
}
}