<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\VipCategory;
use App\Models\VipProduct;

class VipProductController extends Controller
{
    public function index()
    {
        $products = VipProduct::with('category')->latest()->get();
        return view('admin.vip_products.index', compact('products'));
    }

    public function create()
    {
        $categories = VipCategory::where('is_active', 1)->get();
        return view('admin.vip_products.form', compact('categories'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'category_id' => 'required|exists:vip_categories,id',
            'investment_tool' => 'required|string|max:50',
            'price' => 'required|numeric|min:0',
          
            'daily_share_ratio' => 'nullable|numeric|min:0',
            'duration_days' => 'required|integer|min:1',
            'total_profit_limit' => 'nullable|numeric|min:0',
          
           
            'earnings_per_user' => 'required|numeric|min:0',
            'features' => 'nullable|string',
            'is_active' => 'boolean',
            'is_featured' => 'boolean',
        ]);

        VipProduct::create($validated);

        return redirect()->route('admin.vip-products.index')
            ->with('success', 'VIP পণ্য সফলভাবে তৈরি করা হয়েছে!');
    }

    public function edit($id)
    {
        $product = VipProduct::findOrFail($id);
        $categories = VipCategory::active()->get();
        return view('admin.vip_products.form', compact('product', 'categories'));
    }

    public function update(Request $request, $id)
    {
        $product = VipProduct::findOrFail($id);

        $validated = $request->validate([
            'category_id' => 'required|exists:vip_categories,id',
            'investment_tool' => 'required|string|max:50',
            'price' => 'required|numeric|min:0',
           
            'daily_share_ratio' => 'nullable|numeric|min:0',
            'duration_days' => 'required|integer|min:1',
            'total_profit_limit' => 'nullable|numeric|min:0',
           
           
            'earnings_per_user' => 'required|numeric|min:0',
            'features' => 'nullable|string',
            'is_active' => 'boolean',
            'is_featured' => 'boolean',
        ]);

        $product->update($validated);

        return redirect()->route('admin.vip-products.index')
            ->with('success', 'VIP পণ্য সফলভাবে আপডেট করা হয়েছে!');
    }

    public function destroy($id)
    {
        $product = VipProduct::findOrFail($id);
        $product->delete();

        return redirect()->route('admin.vip-products.index')
            ->with('success', 'VIP পণ্য সফলভাবে ডিলিট করা হয়েছে!');
    }
}