<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Transaction;
use Illuminate\Support\Facades\DB;
use App\Models\SupportSetting;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\UsersExport;

use App\Notifications\BalanceUpdatedNotification;
class UserController extends Controller
{
    public function index()
    {
        $users = User::all();
        return view('admin.users.index', compact('users'));
    }

    public function toggleStatus($id)
    {
        $user = User::findOrFail($id);
        $user->status = !$user->status;
        $user->save();

        if(request()->ajax()) {
            return response()->json(['success' => true]);
        }

        return redirect()->back()->with('success', 'User status updated successfully!');
    }

    public function destroy($id)
    {
        $user = User::findOrFail($id);
        $user->delete();

        if(request()->ajax()) {
            return response()->json(['success' => true]);
        }

        return redirect()->back()->with('success', 'User deleted successfully!');
    }
    
    
     public function updateName(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);
        
        try {
            $user = Auth::user();
            $user->name = $request->name;
            $user->save();
            
            return response()->json([
                'success' => true,
                'message' => 'Username updated successfully'
            ]);
            
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to update username'
            ], 500);
        }
    }
    
    
    public function updateBalance(Request $request, $id)
{
    $request->validate([
        'amount' => 'required|numeric|min:0',
        'type' => 'required|in:add,subtract',
        'notes' => 'nullable|string|max:255'
    ]);

    $user = User::findOrFail($id);

    DB::transaction(function () use ($request, $user) {
        if ($request->type === 'add') {
            $user->increment('balance', $request->amount);
            $transactionType = 'admin_credit';
        } else {
            $user->decrement('balance', $request->amount);
            $transactionType = 'admin_debit';
        }

        Transaction::create([
            'user_id' => $user->id,
            'type' => $transactionType,
            'amount' => $request->amount,
            'status' => 'completed',
            'notes' => $request->notes ?? ($request->type === 'add' ? 'Admin credited balance' : 'Admin debited balance'),
            'balance' => $user->balance
        ]);
    });

    return redirect()->back()->with('success', 'ব্যবহারকারীর ব্যালেন্স সফলভাবে আপডেট করা হয়েছে!');
}

   public function myAccount()
{
    $user = Auth::user();
    $totalWithdrawals = $user->withdrawals()->where('status', 'approved')->sum('amount');
    $supportSetting = SupportSetting::first();
    
    return view('user.my-account', compact('user', 'supportSetting', 'totalWithdrawals'));
}
}