<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\SupportSetting;
class SupportSettingController extends Controller
{
   public function edit()
    {
        $support = SupportSetting::first();
        return view('admin.supports.edit', compact('support'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'telegram_link' => 'required|url',
            'telegram_link_2' => 'required|url',
            'support_text' => 'required|string',
        ]);

        SupportSetting::first()->update($request->all());

        return redirect()->route('admin.support.edit')
               ->with('success', 'Support settings updated successfully!');
    }
}
