<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\Models\SeoMeta;
class SeoController extends Controller
{
public function global()
{
    $globalSeo = SeoMeta::firstOrCreate([
        'metaable_id' => 0,
        'metaable_type' => 'global' // Keep as string
    ]);
    
    return view('admin.seo.global', compact('globalSeo'));
}



public function saveGlobal(Request $request)
{
    $validated = $request->validate([
        'meta_title' => 'required|string|max:60',
        'meta_description' => 'required|string|max:160',
        'meta_keywords' => 'required|string',
        'og_image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
    ]);

    $seo = SeoMeta::updateOrCreate(
        [
            'metaable_id' => 0,
            'metaable_type' => 'global'
        ],
        $request->except('og_image')
    );

    if ($request->hasFile('og_image')) {
        // Delete old image if exists
        if ($seo->og_image && file_exists(public_path($seo->og_image))) {
            unlink(public_path($seo->og_image));
        }

        // Store in public directory
        $file = $request->file('og_image');
        $filename = 'og_'.time().'.'.$file->getClientOriginalExtension();
        $path = 'images/seo/'; // public/images/seo/
        
        // Create directory if doesn't exist
        if (!file_exists(public_path($path))) {
            mkdir(public_path($path), 0755, true);
        }

        // Move file to public directory
        $file->move(public_path($path), $filename);
        $seo->og_image = '/'.$path.$filename;
        $seo->save();
    }

    return back()->with('success', 'Global SEO settings saved!');
}


    public function index()
    {
        $seoData = SeoMeta::with('metaable')->paginate(10);
        return view('admin.seo.index', compact('seoData'));
    }

    public function edit($id)
    {
        $seo = SeoMeta::findOrFail($id);
        return view('admin.seo.edit', compact('seo'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'meta_title' => 'nullable|string|max:60',
            'meta_description' => 'nullable|string|max:160',
            'meta_keywords' => 'nullable|string',
            'og_title' => 'nullable|string|max:60',
            'og_description' => 'nullable|string|max:160',
            'og_image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'canonical_url' => 'nullable|url',
        ]);

        $seo = SeoMeta::findOrFail($id);

        if ($request->hasFile('og_image')) {
            $path = $request->file('og_image')->store('public/seo');
            $seo->og_image = Storage::url($path);
        }

        $seo->update($request->except('og_image'));

        return redirect()->route('admin.seo.index')
            ->with('success', 'SEO data updated successfully');
    }
}
