<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Commission;
use Illuminate\Http\Request;

class CommissionController extends Controller
{
    public function edit()
    {
        try {
            $commission = Commission::firstOrFail();
            return view('admin.commissions.edit', compact('commission'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'কমিশন তথ্য লোড করতে সমস্যা হয়েছে: '.$e->getMessage());
        }
    }

    public function update(Request $request)
    {
        $request->validate([
            'description' => 'required|string|max:5000'
        ]);

        try {
            $commission = Commission::firstOrFail();
            $commission->update(['description' => $request->description]);

            return redirect()->route('admin.commissions.edit')
                   ->with('success', '✅ কমিশন নীতি সফলভাবে আপডেট করা হয়েছে!');

        } catch (\Exception $e) {
            return redirect()->back()
                   ->with('error', '❌ কমিশন আপডেট করতে ব্যর্থ: '.$e->getMessage())
                   ->withInput();
        }
    }
}