<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Withdrawal;
use Illuminate\Support\Facades\DB;

class AdminWithdrawalController extends Controller
{
   
public function index()
{
    $withdrawals = Withdrawal::with(['user', 'paymentMethod'])
                    ->latest()
                    ->paginate(20);
    
    return view('admin.withdrawals.index', compact('withdrawals'));
}

    public function pending()
    {
        $withdrawals = Withdrawal::where('status', 'pending')
                        ->with(['user', 'paymentMethod'])
                        ->selectRaw('*, amount as net_amount, (gross_amount - amount) as fee_amount')
                        ->latest()
                        ->paginate(20);
        
        return view('admin.withdrawals.index', compact('withdrawals'));
    }

    public function approved()
    {
        $withdrawals = Withdrawal::where('status', 'approved')
                        ->with(['user', 'paymentMethod'])
                        ->selectRaw('*, amount as net_amount, (gross_amount - amount) as fee_amount')
                        ->latest()
                        ->paginate(20);
        
        return view('admin.withdrawals.index', compact('withdrawals'));
    }

    public function rejected()
    {
        $withdrawals = Withdrawal::where('status', 'rejected')
                        ->with(['user', 'paymentMethod'])
                        ->selectRaw('*, amount as net_amount, (gross_amount - amount) as fee_amount')
                        ->latest()
                        ->paginate(20);
        
        return view('admin.withdrawals.index', compact('withdrawals'));
    }

    public function approve(Withdrawal $withdrawal)
    {
        DB::transaction(function () use ($withdrawal) {
            $withdrawal->update(['status' => 'approved']);
            
            // এখানে পেমেন্ট প্রসেসিং কোড যোগ করুন
            // যেমন: পেমেন্ট গেটওয়ে API কল করা
        });

        return back()->with('success', 'Withdrawal approved successfully');
    }

    public function reject(Withdrawal $withdrawal)
    {
        $withdrawal->update(['status' => 'rejected']);
        
        // ব্যালেন্স ফেরত দেওয়ার কোড
        DB::transaction(function () use ($withdrawal) {
            $user = $withdrawal->user;
            $user->balance += $withdrawal->amount;
            $user->save();
        });

        return back()->with('success', 'Withdrawal rejected and amount returned to user');
    }

    public function process(Withdrawal $withdrawal, Request $request)
    {
        $request->validate([
            'transaction_id' => 'required|string',
            'notes' => 'nullable|string'
        ]);

        $withdrawal->update([
            'status' => 'processed',
            'transaction_id' => $request->transaction_id,
            'notes' => $request->notes
        ]);

        return back()->with('success', 'Withdrawal marked as processed');
    }

 // Add this method to your AdminWithdrawalController
public function destroy(Withdrawal $withdrawal)
{
    try {
        DB::transaction(function () use ($withdrawal) {
            // If withdrawal is approved but not processed, return balance to user
            if ($withdrawal->status === 'approved') {
                $user = $withdrawal->user;
                $user->balance += $withdrawal->amount;
                $user->save();
            }
            
            $withdrawal->delete();
        });
        
        return back()->with('success', 'Withdrawal deleted successfully');
    } catch (\Exception $e) {
        return back()->with('error', 'Failed to delete withdrawal: ' . $e->getMessage());
    }
}
}
