<?php

namespace App\Http\Controllers\Admin;


use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\Admin;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Transaction;
use App\Models\UserVipInvestment; // Add this import
use App\Models\Withdrawal;
use Illuminate\Support\Facades\Storage;


class AdminController extends Controller
{
    public function index()
    {
        return view('admin.login_from');
    }

   public function Dashboard()
{
    // Visitor count (using total users for demo)
    $visitors = User::count();
    
    // Subscribers (users with VIP investments)
     $subscribers = User::whereHas('vipInvestments', function($query) {
        $query->where('expires_at', '>', now())
              ->where('is_active', true);
    })->distinct()->count();
    
    // Total sales (sum of all VIP investments)
    $sales = \App\Models\UserVipInvestment::sum('amount'); // Fully qualified name
    
    // Total withdrawals
    $withdrawals = Withdrawal::where('status', 'approved')->count();
    
    // Recent transactions
    $transactions = Transaction::latest()->take(5)->get();
    
    // Active VIP investments
    $activeInvestments = \App\Models\UserVipInvestment::active()->count(); // Fully qualified name
    
    return view('admin.index', compact(
        'visitors',
        'subscribers',
        'sales',
        'withdrawals',
        'transactions',
        'activeInvestments'
    ));
}


public function vipMembers()
{
    // সঠিকভাবে VIP মেম্বার লিস্ট
    $vipMembers = User::whereHas('vipInvestments', function($query) {
        $query->where('expires_at', '>', now())
              ->where('is_active', true);
    })
    ->withCount(['vipInvestments' => function($query) {
        $query->where('expires_at', '>', now())
              ->where('is_active', true);
    }])
    ->distinct() // ডুপ্লিকেট ইউজার এড়াতে
    ->paginate(10);

    return view('admin.vip_members.index', compact('vipMembers'));
}
public function vipMemberDetails($id)
{
    $member = User::with(['vipInvestments' => function($query) {
        $query->where('expires_at', '>', now())
              ->where('is_active', true)
              ->with('product');
    }])->findOrFail($id);

    return view('admin.vip_members.show', compact('member'));
}
    public function Login(Request $request)
    {
        $check = $request->all();
        if (Auth::guard('admin')->attempt(['email' => $check['email'], 'password' => $check['password']])) {
            return redirect()->route('admin.dashboard')->with('success', 'Admin Login Successfully');
        } else {
            return back()->with('error', 'Invalid Email Or Password');
        }
    }

    public function AdminLogout()
    {
        Auth::guard('admin')->logout();
        return redirect()->route('login_form')->with('success', 'Admin Logout Successfully'); 
    }

    public function AdminRegister()
    {
        return view('admin.admin_register');
    }

    public function AdminRegisterCreate(Request $request)
    {
        Admin::insert([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'created_at' => Carbon::now(),
        ]);

        return redirect()->route('login_form')->with('success', 'Admin Created Successfully');
    }

    public function profile()
    {
        $admin = Auth::guard('admin')->user();
        return view('admin.profile.profile', compact('admin'));
    }

    public function updateProfile(Request $request)
    {
        $admin = Auth::guard('admin')->user();
    
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:admins,email,' . $admin->id,
            'image' => 'nullable|image|max:2048',
            'current_password' => 'nullable|string',
            'new_password' => 'nullable|string|min:6|confirmed',
        ]);
    
        // Handle password update
        if ($request->filled('current_password')) {
            if (!Hash::check($request->current_password, $admin->password)) {
                return redirect()->route('admin.profile')->with('error', 'Current password is incorrect.');
            }
    
            if ($request->filled('new_password')) {
                $admin->password = Hash::make($request->new_password);
            }
        }
    
        // Handle profile image upload
        if ($request->hasFile('image')) {
            // Delete old image if exists
            if ($admin->image && file_exists(public_path($admin->image))) {
                unlink(public_path($admin->image));
            }
    
            // Save new image
            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('profile_images'), $imageName);
    
            // Update the image path in the database
            $data['image'] = 'profile_images/' . $imageName;
        }
    
        // Update the admin profile
        $admin->update($data);

     
        return redirect()->route('admin.profile')->with('success', 'Profile updated successfully.');
    }
    
    
    

    public function allAdmins()
    {
        $admins = Admin::all();
        return view('admin.profile.all_admins', compact('admins'));
    }

    public function editAdmin($id)
    {
        $admin = Admin::findOrFail($id);
        return view('admin.profile.edit_admin', compact('admin'));
    }

    public function updateAdmin(Request $request, $id)
    {
        $admin = Admin::findOrFail($id);

        $data = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:admins,email,' . $id,
            'status' => 'required|in:active,inactive',
        ]);

        $admin->update($data);

        return redirect()->route('admin.all')->with('success', 'Admin updated successfully.');
    }

    public function deleteAdmin($id)
    {
        $admin = Admin::findOrFail($id);
        $admin->delete();

        return redirect()->route('admin.all')->with('success', 'Admin deleted successfully.');
    }
}
