<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Log;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
protected function schedule(Schedule $schedule)
{
    // 1. VIP দৈনিক আয় প্রসেসিং - সকাল ৯টা
    $schedule->command('vip:process-earnings')
             ->dailyAt('09:00')
             ->onSuccess(function () {
                 Log::info('VIP daily earnings processed successfully');
             })
             ->onFailure(function (Exception $e) {
                 Log::error('VIP earnings processing failed: '.$e->getMessage());
             });

    // 2. VIP ইনভেস্টমেন্ট মেয়াদ শেষ চেক - রাত ১২টা
    $schedule->call(function () {
        \App\Models\UserVipInvestment::processExpiredInvestments();
    })->dailyAt('00:00')
      ->name('process-expired-investments')
      ->onSuccess(function () {
          Log::info('Expired VIP investments processed successfully');
      })
      ->onFailure(function (Exception $e) {
          Log::error('Failed to process expired investments: '.$e->getMessage());
      });

    // 3. ডাটাবেস ব্যাকআপ - রাত ৩টা
    $schedule->command('backup:run --only-db')
             ->dailyAt('03:00')
             ->onSuccess(function () {
                 Log::info('Database backup completed successfully');
             });
}

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }

    /**
     * Get the timezone that should be used by default for scheduled events.
     */
    protected function scheduleTimezone(): string
    {
        return 'Asia/Dhaka'; // Set to Bangladesh time
    }
}